(ns
 pandect.algo.whirlpool
 "Whirlpool algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1355 (compute-whirlpool1353 [data1354]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1355 #'compute-whirlpool1353]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1355
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-whirlpool1353
    [data1354]
    (clojure.core/let
     [md__666__auto__
      (java.security.MessageDigest/getInstance "Whirlpool")]
     (.digest md__666__auto__ data1354)))
   java.lang.String
   (compute-whirlpool1353
    [data1354]
    (clojure.core/let
     [data1354 (.getBytes data1354 "UTF-8")]
     (clojure.core/let
      [md__666__auto__
       (java.security.MessageDigest/getInstance "Whirlpool")]
      (.digest md__666__auto__ data1354)))))
  (clojure.core/extend-protocol
   G__1355
   java.io.InputStream
   (compute-whirlpool1353
    [data1354]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "Whirlpool")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1354]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-whirlpool1353
    [data1354]
    (clojure.core/with-open
     [data1354 (clojure.java.io/input-stream data1354)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "Whirlpool")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1354]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1355)
 (do
  (clojure.core/defn
   whirlpool*
   "[Hash] Whirlpool (raw value)"
   [x]
   (compute-whirlpool1353 x))
  (clojure.core/defn
   whirlpool-file*
   "[Hash] Whirlpool (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-whirlpool1353 x)))
  (clojure.core/defn
   whirlpool-bytes
   "[Hash] Whirlpool (value -> byte array)"
   [x]
   (compute-whirlpool1353 x))
  (clojure.core/defn
   whirlpool-file-bytes
   "[Hash] Whirlpool (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-whirlpool1353 x)))
  (clojure.core/defn
   whirlpool
   "[Hash] Whirlpool (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-whirlpool1353 x)))
  (clojure.core/defn
   whirlpool-file
   "[Hash] Whirlpool (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-whirlpool1353 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1363
   (compute-whirlpool1360 [data1361 key1362]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1363 #'compute-whirlpool1360]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1363
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-whirlpool1360
    [data1361 key1362]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "Hmac-Whirlpool")
      msg__542__auto__
      (clojure.core/bytes data1361)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1362 "Hmac-Whirlpool")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-whirlpool1360
    [data1361 key1362]
    (clojure.core/let
     [data1361 (.getBytes data1361 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "Hmac-Whirlpool")
       msg__542__auto__
       (clojure.core/bytes data1361)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1362 "Hmac-Whirlpool")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1363
   java.io.InputStream
   (compute-whirlpool1360
    [data1361 key1362]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "Hmac-Whirlpool")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1362 "Hmac-Whirlpool")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1361]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-whirlpool1360
    [data1361 key1362]
    (clojure.core/with-open
     [data1361 (clojure.java.io/input-stream data1361)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "Hmac-Whirlpool")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1362 "Hmac-Whirlpool")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1361]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1363)
 (do
  (clojure.core/defn
   whirlpool-hmac*
   "[HMAC] Hmac-Whirlpool (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-whirlpool1360
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   whirlpool-hmac-file*
   "[HMAC] Hmac-Whirlpool (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-whirlpool1360
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   whirlpool-hmac-bytes
   "[HMAC] Hmac-Whirlpool (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-whirlpool1360
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   whirlpool-hmac-file-bytes
   "[HMAC] Hmac-Whirlpool (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-whirlpool1360
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   whirlpool-hmac
   "[HMAC] Hmac-Whirlpool (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-whirlpool1360
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   whirlpool-hmac-file
   "[HMAC] Hmac-Whirlpool (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-whirlpool1360
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
