(ns
 pandect.algo.tiger
 "Tiger algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1352 (compute-tiger1350 [data1351]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1352 #'compute-tiger1350]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1352
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-tiger1350
    [data1351]
    (clojure.core/let
     [md__666__auto__
      (java.security.MessageDigest/getInstance "Tiger")]
     (.digest md__666__auto__ data1351)))
   java.lang.String
   (compute-tiger1350
    [data1351]
    (clojure.core/let
     [data1351 (.getBytes data1351 "UTF-8")]
     (clojure.core/let
      [md__666__auto__
       (java.security.MessageDigest/getInstance "Tiger")]
      (.digest md__666__auto__ data1351)))))
  (clojure.core/extend-protocol
   G__1352
   java.io.InputStream
   (compute-tiger1350
    [data1351]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "Tiger")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1351]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-tiger1350
    [data1351]
    (clojure.core/with-open
     [data1351 (clojure.java.io/input-stream data1351)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "Tiger")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1351]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1352)
 (do
  (clojure.core/defn
   tiger*
   "[Hash] Tiger (raw value)"
   [x]
   (compute-tiger1350 x))
  (clojure.core/defn
   tiger-file*
   "[Hash] Tiger (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-tiger1350 x)))
  (clojure.core/defn
   tiger-bytes
   "[Hash] Tiger (value -> byte array)"
   [x]
   (compute-tiger1350 x))
  (clojure.core/defn
   tiger-file-bytes
   "[Hash] Tiger (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-tiger1350 x)))
  (clojure.core/defn
   tiger
   "[Hash] Tiger (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-tiger1350 x)))
  (clojure.core/defn
   tiger-file
   "[Hash] Tiger (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-tiger1350 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1359
   (compute-tiger1356 [data1357 key1358]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1359 #'compute-tiger1356]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1359
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-tiger1356
    [data1357 key1358]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "Hmac-Tiger")
      msg__542__auto__
      (clojure.core/bytes data1357)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1358 "Hmac-Tiger")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-tiger1356
    [data1357 key1358]
    (clojure.core/let
     [data1357 (.getBytes data1357 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "Hmac-Tiger")
       msg__542__auto__
       (clojure.core/bytes data1357)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1358 "Hmac-Tiger")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1359
   java.io.InputStream
   (compute-tiger1356
    [data1357 key1358]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "Hmac-Tiger")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1358 "Hmac-Tiger")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1357]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-tiger1356
    [data1357 key1358]
    (clojure.core/with-open
     [data1357 (clojure.java.io/input-stream data1357)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "Hmac-Tiger")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1358 "Hmac-Tiger")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1357]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1359)
 (do
  (clojure.core/defn
   tiger-hmac*
   "[HMAC] Hmac-Tiger (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-tiger1356
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   tiger-hmac-file*
   "[HMAC] Hmac-Tiger (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-tiger1356
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   tiger-hmac-bytes
   "[HMAC] Hmac-Tiger (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-tiger1356
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   tiger-hmac-file-bytes
   "[HMAC] Hmac-Tiger (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-tiger1356
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   tiger-hmac
   "[HMAC] Hmac-Tiger (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-tiger1356
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   tiger-hmac-file
   "[HMAC] Hmac-Tiger (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-tiger1356
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
