(ns
 pandect.algo.sha512
 "SHA-512 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1300 (compute-sha5121298 [data1299]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1300 #'compute-sha5121298]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1300
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha5121298
    [data1299]
    (clojure.core/let
     [md__666__auto__
      (java.security.MessageDigest/getInstance "SHA-512")]
     (.digest md__666__auto__ data1299)))
   java.lang.String
   (compute-sha5121298
    [data1299]
    (clojure.core/let
     [data1299 (.getBytes data1299 "UTF-8")]
     (clojure.core/let
      [md__666__auto__
       (java.security.MessageDigest/getInstance "SHA-512")]
      (.digest md__666__auto__ data1299)))))
  (clojure.core/extend-protocol
   G__1300
   java.io.InputStream
   (compute-sha5121298
    [data1299]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "SHA-512")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1299]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-sha5121298
    [data1299]
    (clojure.core/with-open
     [data1299 (clojure.java.io/input-stream data1299)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "SHA-512")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1299]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1300)
 (do
  (clojure.core/defn
   sha512*
   "[Hash] SHA-512 (raw value)"
   [x]
   (compute-sha5121298 x))
  (clojure.core/defn
   sha512-file*
   "[Hash] SHA-512 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha5121298 x)))
  (clojure.core/defn
   sha512-bytes
   "[Hash] SHA-512 (value -> byte array)"
   [x]
   (compute-sha5121298 x))
  (clojure.core/defn
   sha512-file-bytes
   "[Hash] SHA-512 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha5121298 x)))
  (clojure.core/defn
   sha512
   "[Hash] SHA-512 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-sha5121298 x)))
  (clojure.core/defn
   sha512-file
   "[Hash] SHA-512 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-sha5121298 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1307
   (compute-sha5121304 [data1305 key1306]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1307 #'compute-sha5121304]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1307
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha5121304
    [data1305 key1306]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "HmacSHA512")
      msg__542__auto__
      (clojure.core/bytes data1305)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1306 "HmacSHA512")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-sha5121304
    [data1305 key1306]
    (clojure.core/let
     [data1305 (.getBytes data1305 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "HmacSHA512")
       msg__542__auto__
       (clojure.core/bytes data1305)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1306 "HmacSHA512")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1307
   java.io.InputStream
   (compute-sha5121304
    [data1305 key1306]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "HmacSHA512")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1306 "HmacSHA512")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1305]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-sha5121304
    [data1305 key1306]
    (clojure.core/with-open
     [data1305 (clojure.java.io/input-stream data1305)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "HmacSHA512")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1306 "HmacSHA512")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1305]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1307)
 (do
  (clojure.core/defn
   sha512-hmac*
   "[HMAC] HmacSHA512 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha5121304
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha512-hmac-file*
   "[HMAC] HmacSHA512 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha5121304
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha512-hmac-bytes
   "[HMAC] HmacSHA512 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha5121304
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha512-hmac-file-bytes
   "[HMAC] HmacSHA512 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha5121304
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha512-hmac
   "[HMAC] HmacSHA512 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-sha5121304
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha512-hmac-file
   "[HMAC] HmacSHA512 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha5121304
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
(do
 (do
  (clojure.core/defprotocol
   G__1344
   (compute-sha5121340 [data1341 key1343])
   (compute-sha5121340-verify [data1341 sig1342 key1343]))
  (clojure.core/doseq
   [v__184__auto__
    [#'G__1344 #'compute-sha5121340 #'compute-sha5121340-verify]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1344
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha5121340
    [data1341 key1343]
    (clojure.core/let
     [signer__845__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA512withRSA")
       (.initSign key1343)
       (.update (clojure.core/bytes data1341)))]
     (.sign signer__845__auto__)))
   (compute-sha5121340-verify
    [data1341 sig1342 key1343]
    (clojure.core/let
     [signer__846__auto__
      (java.security.Signature/getInstance "SHA512withRSA")
      key__847__auto__
      (pandect.utils.convert/as-public-key key1343)]
     (.initVerify signer__846__auto__ key__847__auto__)
     (.update signer__846__auto__ (clojure.core/bytes data1341))
     (.verify signer__846__auto__ (clojure.core/bytes sig1342))))
   java.lang.String
   (compute-sha5121340
    [data1341 key1343]
    (clojure.core/let
     [data1341 (.getBytes data1341 "UTF-8")]
     (clojure.core/let
      [signer__845__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA512withRSA")
        (.initSign key1343)
        (.update (clojure.core/bytes data1341)))]
      (.sign signer__845__auto__))))
   (compute-sha5121340-verify
    [data1341 sig1342 key1343]
    (clojure.core/let
     [data1341 (.getBytes data1341 "UTF-8")]
     (clojure.core/let
      [signer__846__auto__
       (java.security.Signature/getInstance "SHA512withRSA")
       key__847__auto__
       (pandect.utils.convert/as-public-key key1343)]
      (.initVerify signer__846__auto__ key__847__auto__)
      (.update signer__846__auto__ (clojure.core/bytes data1341))
      (.verify signer__846__auto__ (clojure.core/bytes sig1342))))))
  (clojure.core/extend-protocol
   G__1344
   java.io.InputStream
   (compute-sha5121340
    [data1341 key1343]
    (clojure.core/let
     [signer__848__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA512withRSA")
       (.initSign key1343))
      c__849__auto__
      (clojure.core/int *buffer-size*)
      buf__850__auto__
      (clojure.core/byte-array c__849__auto__)
      s__851__auto__
      data1341]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__852__auto__
        (.read s__851__auto__ buf__850__auto__ 0 c__849__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__852__auto__ -1)
        (.update signer__848__auto__ buf__850__auto__ 0 r__852__auto__)
        (recur))))
     (.sign signer__848__auto__)))
   (compute-sha5121340-verify
    [data1341 sig1342 key1343]
    (clojure.core/let
     [signer__853__auto__
      (java.security.Signature/getInstance "SHA512withRSA")
      c__854__auto__
      (clojure.core/int *buffer-size*)
      buf__855__auto__
      (clojure.core/byte-array c__854__auto__)
      s__856__auto__
      data1341
      key__857__auto__
      (pandect.utils.convert/as-public-key key1343)]
     (.initVerify signer__853__auto__ key__857__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__858__auto__
        (.read s__856__auto__ buf__855__auto__ 0 c__854__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__858__auto__ -1)
        (.update signer__853__auto__ buf__855__auto__ 0 r__858__auto__)
        (recur))))
     (.verify signer__853__auto__ (clojure.core/bytes sig1342))))
   java.io.File
   (compute-sha5121340
    [data1341 key1343]
    (clojure.core/with-open
     [data1341 (clojure.java.io/input-stream data1341)]
     (clojure.core/let
      [signer__848__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA512withRSA")
        (.initSign key1343))
       c__849__auto__
       (clojure.core/int *buffer-size*)
       buf__850__auto__
       (clojure.core/byte-array c__849__auto__)
       s__851__auto__
       data1341]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__852__auto__
         (.read s__851__auto__ buf__850__auto__ 0 c__849__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__852__auto__ -1)
         (.update
          signer__848__auto__
          buf__850__auto__
          0
          r__852__auto__)
         (recur))))
      (.sign signer__848__auto__))))
   (compute-sha5121340-verify
    [data1341 sig1342 key1343]
    (clojure.core/with-open
     [data1341 (clojure.java.io/input-stream data1341)]
     (clojure.core/let
      [signer__853__auto__
       (java.security.Signature/getInstance "SHA512withRSA")
       c__854__auto__
       (clojure.core/int *buffer-size*)
       buf__855__auto__
       (clojure.core/byte-array c__854__auto__)
       s__856__auto__
       data1341
       key__857__auto__
       (pandect.utils.convert/as-public-key key1343)]
      (.initVerify signer__853__auto__ key__857__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__858__auto__
         (.read s__856__auto__ buf__855__auto__ 0 c__854__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__858__auto__ -1)
         (.update
          signer__853__auto__
          buf__855__auto__
          0
          r__858__auto__)
         (recur))))
      (.verify signer__853__auto__ (clojure.core/bytes sig1342))))))
  'G__1344)
 (do
  (clojure.core/defn
   sha512-rsa*
   "[Signature] SHA512withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha5121340 x private-key))
  (clojure.core/defn
   sha512-rsa-file*
   "[Signature] SHA512withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha5121340 x private-key)))
  (clojure.core/defn
   sha512-rsa-bytes
   "[Signature] SHA512withRSA (value -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha5121340 x private-key))
  (clojure.core/defn
   sha512-rsa-file-bytes
   "[Signature] SHA512withRSA (file path -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha5121340 x private-key)))
  (clojure.core/defn
   sha512-rsa
   "[Signature] SHA512withRSA (value -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (pandect.utils.convert/bytes->hex
    (compute-sha5121340 x private-key)))
  (clojure.core/defn
   sha512-rsa-file
   "[Signature] SHA512withRSA (file path -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha5121340 x private-key))))
  (clojure.core/defn
   sha512-rsa-verify
   "[Signature] SHA512withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (compute-sha5121340-verify
    x
    (pandect.utils.convert/convert-signature-to-byte-array signature)
    (pandect.utils.convert/convert-to-public-key public-key)))
  (clojure.core/defn
   sha512-rsa-verify-file
   "[Signature] SHA512withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha5121340-verify
     x
     (pandect.utils.convert/convert-signature-to-byte-array signature)
     (pandect.utils.convert/convert-to-public-key public-key))))))
