(ns
 pandect.algo.sha384
 "SHA-384 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1266 (compute-sha3841264 [data1265]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1266 #'compute-sha3841264]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1266
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha3841264
    [data1265]
    (clojure.core/let
     [md__666__auto__
      (java.security.MessageDigest/getInstance "SHA-384")]
     (.digest md__666__auto__ data1265)))
   java.lang.String
   (compute-sha3841264
    [data1265]
    (clojure.core/let
     [data1265 (.getBytes data1265 "UTF-8")]
     (clojure.core/let
      [md__666__auto__
       (java.security.MessageDigest/getInstance "SHA-384")]
      (.digest md__666__auto__ data1265)))))
  (clojure.core/extend-protocol
   G__1266
   java.io.InputStream
   (compute-sha3841264
    [data1265]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "SHA-384")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1265]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-sha3841264
    [data1265]
    (clojure.core/with-open
     [data1265 (clojure.java.io/input-stream data1265)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "SHA-384")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1265]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1266)
 (do
  (clojure.core/defn
   sha384*
   "[Hash] SHA-384 (raw value)"
   [x]
   (compute-sha3841264 x))
  (clojure.core/defn
   sha384-file*
   "[Hash] SHA-384 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841264 x)))
  (clojure.core/defn
   sha384-bytes
   "[Hash] SHA-384 (value -> byte array)"
   [x]
   (compute-sha3841264 x))
  (clojure.core/defn
   sha384-file-bytes
   "[Hash] SHA-384 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841264 x)))
  (clojure.core/defn
   sha384
   "[Hash] SHA-384 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-sha3841264 x)))
  (clojure.core/defn
   sha384-file
   "[Hash] SHA-384 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-sha3841264 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1281
   (compute-sha3841278 [data1279 key1280]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1281 #'compute-sha3841278]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1281
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha3841278
    [data1279 key1280]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "HmacSHA384")
      msg__542__auto__
      (clojure.core/bytes data1279)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1280 "HmacSHA384")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-sha3841278
    [data1279 key1280]
    (clojure.core/let
     [data1279 (.getBytes data1279 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "HmacSHA384")
       msg__542__auto__
       (clojure.core/bytes data1279)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1280 "HmacSHA384")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1281
   java.io.InputStream
   (compute-sha3841278
    [data1279 key1280]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "HmacSHA384")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1280 "HmacSHA384")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1279]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-sha3841278
    [data1279 key1280]
    (clojure.core/with-open
     [data1279 (clojure.java.io/input-stream data1279)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "HmacSHA384")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1280 "HmacSHA384")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1279]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1281)
 (do
  (clojure.core/defn
   sha384-hmac*
   "[HMAC] HmacSHA384 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha3841278
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha384-hmac-file*
   "[HMAC] HmacSHA384 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841278
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha384-hmac-bytes
   "[HMAC] HmacSHA384 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha3841278
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha384-hmac-file-bytes
   "[HMAC] HmacSHA384 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841278
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha384-hmac
   "[HMAC] HmacSHA384 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-sha3841278
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha384-hmac-file
   "[HMAC] HmacSHA384 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha3841278
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
(do
 (do
  (clojure.core/defprotocol
   G__1312
   (compute-sha3841308 [data1309 key1311])
   (compute-sha3841308-verify [data1309 sig1310 key1311]))
  (clojure.core/doseq
   [v__184__auto__
    [#'G__1312 #'compute-sha3841308 #'compute-sha3841308-verify]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1312
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha3841308
    [data1309 key1311]
    (clojure.core/let
     [signer__845__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA384withRSA")
       (.initSign key1311)
       (.update (clojure.core/bytes data1309)))]
     (.sign signer__845__auto__)))
   (compute-sha3841308-verify
    [data1309 sig1310 key1311]
    (clojure.core/let
     [signer__846__auto__
      (java.security.Signature/getInstance "SHA384withRSA")
      key__847__auto__
      (pandect.utils.convert/as-public-key key1311)]
     (.initVerify signer__846__auto__ key__847__auto__)
     (.update signer__846__auto__ (clojure.core/bytes data1309))
     (.verify signer__846__auto__ (clojure.core/bytes sig1310))))
   java.lang.String
   (compute-sha3841308
    [data1309 key1311]
    (clojure.core/let
     [data1309 (.getBytes data1309 "UTF-8")]
     (clojure.core/let
      [signer__845__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA384withRSA")
        (.initSign key1311)
        (.update (clojure.core/bytes data1309)))]
      (.sign signer__845__auto__))))
   (compute-sha3841308-verify
    [data1309 sig1310 key1311]
    (clojure.core/let
     [data1309 (.getBytes data1309 "UTF-8")]
     (clojure.core/let
      [signer__846__auto__
       (java.security.Signature/getInstance "SHA384withRSA")
       key__847__auto__
       (pandect.utils.convert/as-public-key key1311)]
      (.initVerify signer__846__auto__ key__847__auto__)
      (.update signer__846__auto__ (clojure.core/bytes data1309))
      (.verify signer__846__auto__ (clojure.core/bytes sig1310))))))
  (clojure.core/extend-protocol
   G__1312
   java.io.InputStream
   (compute-sha3841308
    [data1309 key1311]
    (clojure.core/let
     [signer__848__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA384withRSA")
       (.initSign key1311))
      c__849__auto__
      (clojure.core/int *buffer-size*)
      buf__850__auto__
      (clojure.core/byte-array c__849__auto__)
      s__851__auto__
      data1309]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__852__auto__
        (.read s__851__auto__ buf__850__auto__ 0 c__849__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__852__auto__ -1)
        (.update signer__848__auto__ buf__850__auto__ 0 r__852__auto__)
        (recur))))
     (.sign signer__848__auto__)))
   (compute-sha3841308-verify
    [data1309 sig1310 key1311]
    (clojure.core/let
     [signer__853__auto__
      (java.security.Signature/getInstance "SHA384withRSA")
      c__854__auto__
      (clojure.core/int *buffer-size*)
      buf__855__auto__
      (clojure.core/byte-array c__854__auto__)
      s__856__auto__
      data1309
      key__857__auto__
      (pandect.utils.convert/as-public-key key1311)]
     (.initVerify signer__853__auto__ key__857__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__858__auto__
        (.read s__856__auto__ buf__855__auto__ 0 c__854__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__858__auto__ -1)
        (.update signer__853__auto__ buf__855__auto__ 0 r__858__auto__)
        (recur))))
     (.verify signer__853__auto__ (clojure.core/bytes sig1310))))
   java.io.File
   (compute-sha3841308
    [data1309 key1311]
    (clojure.core/with-open
     [data1309 (clojure.java.io/input-stream data1309)]
     (clojure.core/let
      [signer__848__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA384withRSA")
        (.initSign key1311))
       c__849__auto__
       (clojure.core/int *buffer-size*)
       buf__850__auto__
       (clojure.core/byte-array c__849__auto__)
       s__851__auto__
       data1309]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__852__auto__
         (.read s__851__auto__ buf__850__auto__ 0 c__849__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__852__auto__ -1)
         (.update
          signer__848__auto__
          buf__850__auto__
          0
          r__852__auto__)
         (recur))))
      (.sign signer__848__auto__))))
   (compute-sha3841308-verify
    [data1309 sig1310 key1311]
    (clojure.core/with-open
     [data1309 (clojure.java.io/input-stream data1309)]
     (clojure.core/let
      [signer__853__auto__
       (java.security.Signature/getInstance "SHA384withRSA")
       c__854__auto__
       (clojure.core/int *buffer-size*)
       buf__855__auto__
       (clojure.core/byte-array c__854__auto__)
       s__856__auto__
       data1309
       key__857__auto__
       (pandect.utils.convert/as-public-key key1311)]
      (.initVerify signer__853__auto__ key__857__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__858__auto__
         (.read s__856__auto__ buf__855__auto__ 0 c__854__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__858__auto__ -1)
         (.update
          signer__853__auto__
          buf__855__auto__
          0
          r__858__auto__)
         (recur))))
      (.verify signer__853__auto__ (clojure.core/bytes sig1310))))))
  'G__1312)
 (do
  (clojure.core/defn
   sha384-rsa*
   "[Signature] SHA384withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha3841308 x private-key))
  (clojure.core/defn
   sha384-rsa-file*
   "[Signature] SHA384withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841308 x private-key)))
  (clojure.core/defn
   sha384-rsa-bytes
   "[Signature] SHA384withRSA (value -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha3841308 x private-key))
  (clojure.core/defn
   sha384-rsa-file-bytes
   "[Signature] SHA384withRSA (file path -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841308 x private-key)))
  (clojure.core/defn
   sha384-rsa
   "[Signature] SHA384withRSA (value -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (pandect.utils.convert/bytes->hex
    (compute-sha3841308 x private-key)))
  (clojure.core/defn
   sha384-rsa-file
   "[Signature] SHA384withRSA (file path -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha3841308 x private-key))))
  (clojure.core/defn
   sha384-rsa-verify
   "[Signature] SHA384withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (compute-sha3841308-verify
    x
    (pandect.utils.convert/convert-signature-to-byte-array signature)
    (pandect.utils.convert/convert-to-public-key public-key)))
  (clojure.core/defn
   sha384-rsa-verify-file
   "[Signature] SHA384withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841308-verify
     x
     (pandect.utils.convert/convert-signature-to-byte-array signature)
     (pandect.utils.convert/convert-to-public-key public-key))))))
