(ns
 pandect.algo.sha1
 "SHA-1 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1260 (compute-sha11258 [data1259]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1260 #'compute-sha11258]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1260
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha11258
    [data1259]
    (clojure.core/let
     [md__666__auto__
      (java.security.MessageDigest/getInstance "SHA-1")]
     (.digest md__666__auto__ data1259)))
   java.lang.String
   (compute-sha11258
    [data1259]
    (clojure.core/let
     [data1259 (.getBytes data1259 "UTF-8")]
     (clojure.core/let
      [md__666__auto__
       (java.security.MessageDigest/getInstance "SHA-1")]
      (.digest md__666__auto__ data1259)))))
  (clojure.core/extend-protocol
   G__1260
   java.io.InputStream
   (compute-sha11258
    [data1259]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "SHA-1")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1259]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-sha11258
    [data1259]
    (clojure.core/with-open
     [data1259 (clojure.java.io/input-stream data1259)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "SHA-1")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1259]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1260)
 (do
  (clojure.core/defn
   sha1*
   "[Hash] SHA-1 (raw value)"
   [x]
   (compute-sha11258 x))
  (clojure.core/defn
   sha1-file*
   "[Hash] SHA-1 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11258 x)))
  (clojure.core/defn
   sha1-bytes
   "[Hash] SHA-1 (value -> byte array)"
   [x]
   (compute-sha11258 x))
  (clojure.core/defn
   sha1-file-bytes
   "[Hash] SHA-1 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11258 x)))
  (clojure.core/defn
   sha1
   "[Hash] SHA-1 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-sha11258 x)))
  (clojure.core/defn
   sha1-file
   "[Hash] SHA-1 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-sha11258 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1289
   (compute-sha11286 [data1287 key1288]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1289 #'compute-sha11286]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1289
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha11286
    [data1287 key1288]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "HmacSHA1")
      msg__542__auto__
      (clojure.core/bytes data1287)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1288 "HmacSHA1")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-sha11286
    [data1287 key1288]
    (clojure.core/let
     [data1287 (.getBytes data1287 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "HmacSHA1")
       msg__542__auto__
       (clojure.core/bytes data1287)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1288 "HmacSHA1")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1289
   java.io.InputStream
   (compute-sha11286
    [data1287 key1288]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "HmacSHA1")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1288 "HmacSHA1")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1287]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-sha11286
    [data1287 key1288]
    (clojure.core/with-open
     [data1287 (clojure.java.io/input-stream data1287)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "HmacSHA1")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1288 "HmacSHA1")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1287]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1289)
 (do
  (clojure.core/defn
   sha1-hmac*
   "[HMAC] HmacSHA1 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha11286
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha1-hmac-file*
   "[HMAC] HmacSHA1 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11286
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha1-hmac-bytes
   "[HMAC] HmacSHA1 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha11286
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha1-hmac-file-bytes
   "[HMAC] HmacSHA1 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11286
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha1-hmac
   "[HMAC] HmacSHA1 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-sha11286
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha1-hmac-file
   "[HMAC] HmacSHA1 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha11286
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
(do
 (do
  (clojure.core/defprotocol
   G__1322
   (compute-sha11318 [data1319 key1321])
   (compute-sha11318-verify [data1319 sig1320 key1321]))
  (clojure.core/doseq
   [v__184__auto__
    [#'G__1322 #'compute-sha11318 #'compute-sha11318-verify]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1322
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha11318
    [data1319 key1321]
    (clojure.core/let
     [signer__845__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA1withRSA")
       (.initSign key1321)
       (.update (clojure.core/bytes data1319)))]
     (.sign signer__845__auto__)))
   (compute-sha11318-verify
    [data1319 sig1320 key1321]
    (clojure.core/let
     [signer__846__auto__
      (java.security.Signature/getInstance "SHA1withRSA")
      key__847__auto__
      (pandect.utils.convert/as-public-key key1321)]
     (.initVerify signer__846__auto__ key__847__auto__)
     (.update signer__846__auto__ (clojure.core/bytes data1319))
     (.verify signer__846__auto__ (clojure.core/bytes sig1320))))
   java.lang.String
   (compute-sha11318
    [data1319 key1321]
    (clojure.core/let
     [data1319 (.getBytes data1319 "UTF-8")]
     (clojure.core/let
      [signer__845__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA1withRSA")
        (.initSign key1321)
        (.update (clojure.core/bytes data1319)))]
      (.sign signer__845__auto__))))
   (compute-sha11318-verify
    [data1319 sig1320 key1321]
    (clojure.core/let
     [data1319 (.getBytes data1319 "UTF-8")]
     (clojure.core/let
      [signer__846__auto__
       (java.security.Signature/getInstance "SHA1withRSA")
       key__847__auto__
       (pandect.utils.convert/as-public-key key1321)]
      (.initVerify signer__846__auto__ key__847__auto__)
      (.update signer__846__auto__ (clojure.core/bytes data1319))
      (.verify signer__846__auto__ (clojure.core/bytes sig1320))))))
  (clojure.core/extend-protocol
   G__1322
   java.io.InputStream
   (compute-sha11318
    [data1319 key1321]
    (clojure.core/let
     [signer__848__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA1withRSA")
       (.initSign key1321))
      c__849__auto__
      (clojure.core/int *buffer-size*)
      buf__850__auto__
      (clojure.core/byte-array c__849__auto__)
      s__851__auto__
      data1319]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__852__auto__
        (.read s__851__auto__ buf__850__auto__ 0 c__849__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__852__auto__ -1)
        (.update signer__848__auto__ buf__850__auto__ 0 r__852__auto__)
        (recur))))
     (.sign signer__848__auto__)))
   (compute-sha11318-verify
    [data1319 sig1320 key1321]
    (clojure.core/let
     [signer__853__auto__
      (java.security.Signature/getInstance "SHA1withRSA")
      c__854__auto__
      (clojure.core/int *buffer-size*)
      buf__855__auto__
      (clojure.core/byte-array c__854__auto__)
      s__856__auto__
      data1319
      key__857__auto__
      (pandect.utils.convert/as-public-key key1321)]
     (.initVerify signer__853__auto__ key__857__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__858__auto__
        (.read s__856__auto__ buf__855__auto__ 0 c__854__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__858__auto__ -1)
        (.update signer__853__auto__ buf__855__auto__ 0 r__858__auto__)
        (recur))))
     (.verify signer__853__auto__ (clojure.core/bytes sig1320))))
   java.io.File
   (compute-sha11318
    [data1319 key1321]
    (clojure.core/with-open
     [data1319 (clojure.java.io/input-stream data1319)]
     (clojure.core/let
      [signer__848__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA1withRSA")
        (.initSign key1321))
       c__849__auto__
       (clojure.core/int *buffer-size*)
       buf__850__auto__
       (clojure.core/byte-array c__849__auto__)
       s__851__auto__
       data1319]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__852__auto__
         (.read s__851__auto__ buf__850__auto__ 0 c__849__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__852__auto__ -1)
         (.update
          signer__848__auto__
          buf__850__auto__
          0
          r__852__auto__)
         (recur))))
      (.sign signer__848__auto__))))
   (compute-sha11318-verify
    [data1319 sig1320 key1321]
    (clojure.core/with-open
     [data1319 (clojure.java.io/input-stream data1319)]
     (clojure.core/let
      [signer__853__auto__
       (java.security.Signature/getInstance "SHA1withRSA")
       c__854__auto__
       (clojure.core/int *buffer-size*)
       buf__855__auto__
       (clojure.core/byte-array c__854__auto__)
       s__856__auto__
       data1319
       key__857__auto__
       (pandect.utils.convert/as-public-key key1321)]
      (.initVerify signer__853__auto__ key__857__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__858__auto__
         (.read s__856__auto__ buf__855__auto__ 0 c__854__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__858__auto__ -1)
         (.update
          signer__853__auto__
          buf__855__auto__
          0
          r__858__auto__)
         (recur))))
      (.verify signer__853__auto__ (clojure.core/bytes sig1320))))))
  'G__1322)
 (do
  (clojure.core/defn
   sha1-rsa*
   "[Signature] SHA1withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha11318 x private-key))
  (clojure.core/defn
   sha1-rsa-file*
   "[Signature] SHA1withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11318 x private-key)))
  (clojure.core/defn
   sha1-rsa-bytes
   "[Signature] SHA1withRSA (value -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha11318 x private-key))
  (clojure.core/defn
   sha1-rsa-file-bytes
   "[Signature] SHA1withRSA (file path -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11318 x private-key)))
  (clojure.core/defn
   sha1-rsa
   "[Signature] SHA1withRSA (value -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (pandect.utils.convert/bytes->hex (compute-sha11318 x private-key)))
  (clojure.core/defn
   sha1-rsa-file
   "[Signature] SHA1withRSA (file path -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha11318 x private-key))))
  (clojure.core/defn
   sha1-rsa-verify
   "[Signature] SHA1withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (compute-sha11318-verify
    x
    (pandect.utils.convert/convert-signature-to-byte-array signature)
    (pandect.utils.convert/convert-to-public-key public-key)))
  (clojure.core/defn
   sha1-rsa-verify-file
   "[Signature] SHA1withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11318-verify
     x
     (pandect.utils.convert/convert-signature-to-byte-array signature)
     (pandect.utils.convert/convert-to-public-key public-key))))))
(do
 (do
  (clojure.core/defprotocol
   G__1349
   (compute-sha11345 [data1346 key1348])
   (compute-sha11345-verify [data1346 sig1347 key1348]))
  (clojure.core/doseq
   [v__184__auto__
    [#'G__1349 #'compute-sha11345 #'compute-sha11345-verify]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1349
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha11345
    [data1346 key1348]
    (clojure.core/let
     [signer__845__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA1withDSA")
       (.initSign key1348)
       (.update (clojure.core/bytes data1346)))]
     (.sign signer__845__auto__)))
   (compute-sha11345-verify
    [data1346 sig1347 key1348]
    (clojure.core/let
     [signer__846__auto__
      (java.security.Signature/getInstance "SHA1withDSA")
      key__847__auto__
      (pandect.utils.convert/as-public-key key1348)]
     (.initVerify signer__846__auto__ key__847__auto__)
     (.update signer__846__auto__ (clojure.core/bytes data1346))
     (.verify signer__846__auto__ (clojure.core/bytes sig1347))))
   java.lang.String
   (compute-sha11345
    [data1346 key1348]
    (clojure.core/let
     [data1346 (.getBytes data1346 "UTF-8")]
     (clojure.core/let
      [signer__845__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA1withDSA")
        (.initSign key1348)
        (.update (clojure.core/bytes data1346)))]
      (.sign signer__845__auto__))))
   (compute-sha11345-verify
    [data1346 sig1347 key1348]
    (clojure.core/let
     [data1346 (.getBytes data1346 "UTF-8")]
     (clojure.core/let
      [signer__846__auto__
       (java.security.Signature/getInstance "SHA1withDSA")
       key__847__auto__
       (pandect.utils.convert/as-public-key key1348)]
      (.initVerify signer__846__auto__ key__847__auto__)
      (.update signer__846__auto__ (clojure.core/bytes data1346))
      (.verify signer__846__auto__ (clojure.core/bytes sig1347))))))
  (clojure.core/extend-protocol
   G__1349
   java.io.InputStream
   (compute-sha11345
    [data1346 key1348]
    (clojure.core/let
     [signer__848__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA1withDSA")
       (.initSign key1348))
      c__849__auto__
      (clojure.core/int *buffer-size*)
      buf__850__auto__
      (clojure.core/byte-array c__849__auto__)
      s__851__auto__
      data1346]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__852__auto__
        (.read s__851__auto__ buf__850__auto__ 0 c__849__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__852__auto__ -1)
        (.update signer__848__auto__ buf__850__auto__ 0 r__852__auto__)
        (recur))))
     (.sign signer__848__auto__)))
   (compute-sha11345-verify
    [data1346 sig1347 key1348]
    (clojure.core/let
     [signer__853__auto__
      (java.security.Signature/getInstance "SHA1withDSA")
      c__854__auto__
      (clojure.core/int *buffer-size*)
      buf__855__auto__
      (clojure.core/byte-array c__854__auto__)
      s__856__auto__
      data1346
      key__857__auto__
      (pandect.utils.convert/as-public-key key1348)]
     (.initVerify signer__853__auto__ key__857__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__858__auto__
        (.read s__856__auto__ buf__855__auto__ 0 c__854__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__858__auto__ -1)
        (.update signer__853__auto__ buf__855__auto__ 0 r__858__auto__)
        (recur))))
     (.verify signer__853__auto__ (clojure.core/bytes sig1347))))
   java.io.File
   (compute-sha11345
    [data1346 key1348]
    (clojure.core/with-open
     [data1346 (clojure.java.io/input-stream data1346)]
     (clojure.core/let
      [signer__848__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA1withDSA")
        (.initSign key1348))
       c__849__auto__
       (clojure.core/int *buffer-size*)
       buf__850__auto__
       (clojure.core/byte-array c__849__auto__)
       s__851__auto__
       data1346]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__852__auto__
         (.read s__851__auto__ buf__850__auto__ 0 c__849__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__852__auto__ -1)
         (.update
          signer__848__auto__
          buf__850__auto__
          0
          r__852__auto__)
         (recur))))
      (.sign signer__848__auto__))))
   (compute-sha11345-verify
    [data1346 sig1347 key1348]
    (clojure.core/with-open
     [data1346 (clojure.java.io/input-stream data1346)]
     (clojure.core/let
      [signer__853__auto__
       (java.security.Signature/getInstance "SHA1withDSA")
       c__854__auto__
       (clojure.core/int *buffer-size*)
       buf__855__auto__
       (clojure.core/byte-array c__854__auto__)
       s__856__auto__
       data1346
       key__857__auto__
       (pandect.utils.convert/as-public-key key1348)]
      (.initVerify signer__853__auto__ key__857__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__858__auto__
         (.read s__856__auto__ buf__855__auto__ 0 c__854__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__858__auto__ -1)
         (.update
          signer__853__auto__
          buf__855__auto__
          0
          r__858__auto__)
         (recur))))
      (.verify signer__853__auto__ (clojure.core/bytes sig1347))))))
  'G__1349)
 (do
  (clojure.core/defn
   sha1-dsa*
   "[Signature] SHA1withDSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha11345 x private-key))
  (clojure.core/defn
   sha1-dsa-file*
   "[Signature] SHA1withDSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11345 x private-key)))
  (clojure.core/defn
   sha1-dsa-bytes
   "[Signature] SHA1withDSA (value -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha11345 x private-key))
  (clojure.core/defn
   sha1-dsa-file-bytes
   "[Signature] SHA1withDSA (file path -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11345 x private-key)))
  (clojure.core/defn
   sha1-dsa
   "[Signature] SHA1withDSA (value -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (pandect.utils.convert/bytes->hex (compute-sha11345 x private-key)))
  (clojure.core/defn
   sha1-dsa-file
   "[Signature] SHA1withDSA (file path -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha11345 x private-key))))
  (clojure.core/defn
   sha1-dsa-verify
   "[Signature] SHA1withDSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (compute-sha11345-verify
    x
    (pandect.utils.convert/convert-signature-to-byte-array signature)
    (pandect.utils.convert/convert-to-public-key public-key)))
  (clojure.core/defn
   sha1-dsa-verify-file
   "[Signature] SHA1withDSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha11345-verify
     x
     (pandect.utils.convert/convert-signature-to-byte-array signature)
     (pandect.utils.convert/convert-to-public-key public-key))))))
