(ns
 pandect.algo.ripemd256
 "RipeMD256 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1223 (compute-ripemd2561221 [data1222]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1223 #'compute-ripemd2561221]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1223
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-ripemd2561221
    [data1222]
    (clojure.core/let
     [md__666__auto__
      (java.security.MessageDigest/getInstance "RipeMD256")]
     (.digest md__666__auto__ data1222)))
   java.lang.String
   (compute-ripemd2561221
    [data1222]
    (clojure.core/let
     [data1222 (.getBytes data1222 "UTF-8")]
     (clojure.core/let
      [md__666__auto__
       (java.security.MessageDigest/getInstance "RipeMD256")]
      (.digest md__666__auto__ data1222)))))
  (clojure.core/extend-protocol
   G__1223
   java.io.InputStream
   (compute-ripemd2561221
    [data1222]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "RipeMD256")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1222]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-ripemd2561221
    [data1222]
    (clojure.core/with-open
     [data1222 (clojure.java.io/input-stream data1222)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "RipeMD256")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1222]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1223)
 (do
  (clojure.core/defn
   ripemd256*
   "[Hash] RipeMD256 (raw value)"
   [x]
   (compute-ripemd2561221 x))
  (clojure.core/defn
   ripemd256-file*
   "[Hash] RipeMD256 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd2561221 x)))
  (clojure.core/defn
   ripemd256-bytes
   "[Hash] RipeMD256 (value -> byte array)"
   [x]
   (compute-ripemd2561221 x))
  (clojure.core/defn
   ripemd256-file-bytes
   "[Hash] RipeMD256 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd2561221 x)))
  (clojure.core/defn
   ripemd256
   "[Hash] RipeMD256 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-ripemd2561221 x)))
  (clojure.core/defn
   ripemd256-file
   "[Hash] RipeMD256 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-ripemd2561221 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1249
   (compute-ripemd2561246 [data1247 key1248]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1249 #'compute-ripemd2561246]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1249
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-ripemd2561246
    [data1247 key1248]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "Hmac-RipeMD256")
      msg__542__auto__
      (clojure.core/bytes data1247)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1248 "Hmac-RipeMD256")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-ripemd2561246
    [data1247 key1248]
    (clojure.core/let
     [data1247 (.getBytes data1247 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "Hmac-RipeMD256")
       msg__542__auto__
       (clojure.core/bytes data1247)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1248 "Hmac-RipeMD256")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1249
   java.io.InputStream
   (compute-ripemd2561246
    [data1247 key1248]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "Hmac-RipeMD256")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1248 "Hmac-RipeMD256")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1247]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-ripemd2561246
    [data1247 key1248]
    (clojure.core/with-open
     [data1247 (clojure.java.io/input-stream data1247)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "Hmac-RipeMD256")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1248 "Hmac-RipeMD256")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1247]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1249)
 (do
  (clojure.core/defn
   ripemd256-hmac*
   "[HMAC] Hmac-RipeMD256 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-ripemd2561246
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   ripemd256-hmac-file*
   "[HMAC] Hmac-RipeMD256 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd2561246
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd256-hmac-bytes
   "[HMAC] Hmac-RipeMD256 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-ripemd2561246
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   ripemd256-hmac-file-bytes
   "[HMAC] Hmac-RipeMD256 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd2561246
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd256-hmac
   "[HMAC] Hmac-RipeMD256 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-ripemd2561246
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd256-hmac-file
   "[HMAC] Hmac-RipeMD256 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-ripemd2561246
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
