(ns
 pandect.algo.ripemd128
 "RipeMD128 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1232 (compute-ripemd1281230 [data1231]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1232 #'compute-ripemd1281230]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1232
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-ripemd1281230
    [data1231]
    (clojure.core/let
     [md__666__auto__
      (java.security.MessageDigest/getInstance "RipeMD128")]
     (.digest md__666__auto__ data1231)))
   java.lang.String
   (compute-ripemd1281230
    [data1231]
    (clojure.core/let
     [data1231 (.getBytes data1231 "UTF-8")]
     (clojure.core/let
      [md__666__auto__
       (java.security.MessageDigest/getInstance "RipeMD128")]
      (.digest md__666__auto__ data1231)))))
  (clojure.core/extend-protocol
   G__1232
   java.io.InputStream
   (compute-ripemd1281230
    [data1231]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "RipeMD128")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1231]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-ripemd1281230
    [data1231]
    (clojure.core/with-open
     [data1231 (clojure.java.io/input-stream data1231)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "RipeMD128")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1231]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1232)
 (do
  (clojure.core/defn
   ripemd128*
   "[Hash] RipeMD128 (raw value)"
   [x]
   (compute-ripemd1281230 x))
  (clojure.core/defn
   ripemd128-file*
   "[Hash] RipeMD128 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd1281230 x)))
  (clojure.core/defn
   ripemd128-bytes
   "[Hash] RipeMD128 (value -> byte array)"
   [x]
   (compute-ripemd1281230 x))
  (clojure.core/defn
   ripemd128-file-bytes
   "[Hash] RipeMD128 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd1281230 x)))
  (clojure.core/defn
   ripemd128
   "[Hash] RipeMD128 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-ripemd1281230 x)))
  (clojure.core/defn
   ripemd128-file
   "[Hash] RipeMD128 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-ripemd1281230 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1253
   (compute-ripemd1281250 [data1251 key1252]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1253 #'compute-ripemd1281250]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1253
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-ripemd1281250
    [data1251 key1252]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "Hmac-RipeMD128")
      msg__542__auto__
      (clojure.core/bytes data1251)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1252 "Hmac-RipeMD128")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-ripemd1281250
    [data1251 key1252]
    (clojure.core/let
     [data1251 (.getBytes data1251 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "Hmac-RipeMD128")
       msg__542__auto__
       (clojure.core/bytes data1251)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1252 "Hmac-RipeMD128")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1253
   java.io.InputStream
   (compute-ripemd1281250
    [data1251 key1252]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "Hmac-RipeMD128")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1252 "Hmac-RipeMD128")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1251]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-ripemd1281250
    [data1251 key1252]
    (clojure.core/with-open
     [data1251 (clojure.java.io/input-stream data1251)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "Hmac-RipeMD128")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1252 "Hmac-RipeMD128")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1251]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1253)
 (do
  (clojure.core/defn
   ripemd128-hmac*
   "[HMAC] Hmac-RipeMD128 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-ripemd1281250
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   ripemd128-hmac-file*
   "[HMAC] Hmac-RipeMD128 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd1281250
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd128-hmac-bytes
   "[HMAC] Hmac-RipeMD128 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-ripemd1281250
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   ripemd128-hmac-file-bytes
   "[HMAC] Hmac-RipeMD128 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd1281250
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd128-hmac
   "[HMAC] Hmac-RipeMD128 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-ripemd1281250
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd128-hmac-file
   "[HMAC] Hmac-RipeMD128 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-ripemd1281250
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
