(ns
 pandect.algo.keccak-384
 "Keccak-384 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol
   G__1183
   (compute-keccak-3841179 [data1182]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1183 #'compute-keccak-3841179]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1183
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-keccak-3841179
    [data1182]
    (clojure.core/let
     [md__666__auto__
      (java.security.MessageDigest/getInstance "Keccak-384")]
     (.digest md__666__auto__ data1182)))
   java.lang.String
   (compute-keccak-3841179
    [data1182]
    (clojure.core/let
     [data1182 (.getBytes data1182 "UTF-8")]
     (clojure.core/let
      [md__666__auto__
       (java.security.MessageDigest/getInstance "Keccak-384")]
      (.digest md__666__auto__ data1182)))))
  (clojure.core/extend-protocol
   G__1183
   java.io.InputStream
   (compute-keccak-3841179
    [data1182]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "Keccak-384")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1182]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-keccak-3841179
    [data1182]
    (clojure.core/with-open
     [data1182 (clojure.java.io/input-stream data1182)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "Keccak-384")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1182]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1183)
 (do
  (clojure.core/defn
   keccak-384*
   "[Hash] Keccak-384 (raw value)"
   [x]
   (compute-keccak-3841179 x))
  (clojure.core/defn
   keccak-384-file*
   "[Hash] Keccak-384 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-3841179 x)))
  (clojure.core/defn
   keccak-384-bytes
   "[Hash] Keccak-384 (value -> byte array)"
   [x]
   (compute-keccak-3841179 x))
  (clojure.core/defn
   keccak-384-file-bytes
   "[Hash] Keccak-384 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-3841179 x)))
  (clojure.core/defn
   keccak-384
   "[Hash] Keccak-384 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-keccak-3841179 x)))
  (clojure.core/defn
   keccak-384-file
   "[Hash] Keccak-384 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-keccak-3841179 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1202
   (compute-keccak-3841199 [data1200 key1201]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1202 #'compute-keccak-3841199]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1202
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-keccak-3841199
    [data1200 key1201]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "Hmac-Keccak384")
      msg__542__auto__
      (clojure.core/bytes data1200)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1201 "Hmac-Keccak384")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-keccak-3841199
    [data1200 key1201]
    (clojure.core/let
     [data1200 (.getBytes data1200 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "Hmac-Keccak384")
       msg__542__auto__
       (clojure.core/bytes data1200)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1201 "Hmac-Keccak384")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1202
   java.io.InputStream
   (compute-keccak-3841199
    [data1200 key1201]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "Hmac-Keccak384")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1201 "Hmac-Keccak384")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1200]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-keccak-3841199
    [data1200 key1201]
    (clojure.core/with-open
     [data1200 (clojure.java.io/input-stream data1200)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "Hmac-Keccak384")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1201 "Hmac-Keccak384")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1200]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1202)
 (do
  (clojure.core/defn
   keccak-384-hmac*
   "[HMAC] Hmac-Keccak384 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-keccak-3841199
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   keccak-384-hmac-file*
   "[HMAC] Hmac-Keccak384 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-3841199
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-384-hmac-bytes
   "[HMAC] Hmac-Keccak384 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-keccak-3841199
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   keccak-384-hmac-file-bytes
   "[HMAC] Hmac-Keccak384 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-3841199
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-384-hmac
   "[HMAC] Hmac-Keccak384 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-keccak-3841199
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-384-hmac-file
   "[HMAC] Hmac-Keccak384 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-keccak-3841199
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
