(ns
 pandect.algo.keccak-224
 "Keccak-224 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol
   G__1169
   (compute-keccak-2241163 [data1167]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1169 #'compute-keccak-2241163]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1169
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-keccak-2241163
    [data1167]
    (clojure.core/let
     [md__666__auto__
      (java.security.MessageDigest/getInstance "Keccak-224")]
     (.digest md__666__auto__ data1167)))
   java.lang.String
   (compute-keccak-2241163
    [data1167]
    (clojure.core/let
     [data1167 (.getBytes data1167 "UTF-8")]
     (clojure.core/let
      [md__666__auto__
       (java.security.MessageDigest/getInstance "Keccak-224")]
      (.digest md__666__auto__ data1167)))))
  (clojure.core/extend-protocol
   G__1169
   java.io.InputStream
   (compute-keccak-2241163
    [data1167]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "Keccak-224")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1167]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-keccak-2241163
    [data1167]
    (clojure.core/with-open
     [data1167 (clojure.java.io/input-stream data1167)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "Keccak-224")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1167]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1169)
 (do
  (clojure.core/defn
   keccak-224*
   "[Hash] Keccak-224 (raw value)"
   [x]
   (compute-keccak-2241163 x))
  (clojure.core/defn
   keccak-224-file*
   "[Hash] Keccak-224 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-2241163 x)))
  (clojure.core/defn
   keccak-224-bytes
   "[Hash] Keccak-224 (value -> byte array)"
   [x]
   (compute-keccak-2241163 x))
  (clojure.core/defn
   keccak-224-file-bytes
   "[Hash] Keccak-224 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-2241163 x)))
  (clojure.core/defn
   keccak-224
   "[Hash] Keccak-224 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-keccak-2241163 x)))
  (clojure.core/defn
   keccak-224-file
   "[Hash] Keccak-224 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-keccak-2241163 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1214
   (compute-keccak-2241211 [data1212 key1213]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1214 #'compute-keccak-2241211]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1214
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-keccak-2241211
    [data1212 key1213]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "Hmac-Keccak224")
      msg__542__auto__
      (clojure.core/bytes data1212)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1213 "Hmac-Keccak224")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-keccak-2241211
    [data1212 key1213]
    (clojure.core/let
     [data1212 (.getBytes data1212 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "Hmac-Keccak224")
       msg__542__auto__
       (clojure.core/bytes data1212)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1213 "Hmac-Keccak224")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1214
   java.io.InputStream
   (compute-keccak-2241211
    [data1212 key1213]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "Hmac-Keccak224")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1213 "Hmac-Keccak224")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1212]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-keccak-2241211
    [data1212 key1213]
    (clojure.core/with-open
     [data1212 (clojure.java.io/input-stream data1212)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "Hmac-Keccak224")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1213 "Hmac-Keccak224")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1212]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1214)
 (do
  (clojure.core/defn
   keccak-224-hmac*
   "[HMAC] Hmac-Keccak224 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-keccak-2241211
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   keccak-224-hmac-file*
   "[HMAC] Hmac-Keccak224 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-2241211
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-224-hmac-bytes
   "[HMAC] Hmac-Keccak224 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-keccak-2241211
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   keccak-224-hmac-file-bytes
   "[HMAC] Hmac-Keccak224 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-2241211
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-224-hmac
   "[HMAC] Hmac-Keccak224 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-keccak-2241211
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-224-hmac-file
   "[HMAC] Hmac-Keccak224 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-keccak-2241211
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
