(ns net.cgrand.enlive.reload)

(defn declare-dependency [ns dep type]
  (alter-meta! *ns* update-in [::dependencies] (fnil conj #{}) [dep]))

(defmulti stale-dep? (fn [dep type] type))

#_(defmethod stale-dep? :resource )
(defmethod stale-dep? :ns [dep type] 
  (require dep :reload))

(defn stale-ns? [ns]
  (some #(apply stale-dep? %) (-> ns meta ::dependencies)))

(defn reload-ns [ns]
  (when-not (-> ns meta ::no-reload)
    ; reset deps to remove dead entries
    (alter-meta! ns assoc ::dependencies #{})
    (require (ns-name ns) :reload)))

(defn refresh
  ([] (refresh all-ns))
  ([nses]
    (doseq [ns nses :when (stale-ns? ns)]
      (reload-ns ns))))