(ns
 pandect.algo.siphash
 "Siphash-2-4 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol
   G__1339
   (compute-siphash1336 [data1337 key1338]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1339 #'compute-siphash1336]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1339
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-siphash1336
    [data1337 key1338]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "Siphash-2-4")
      msg__542__auto__
      (clojure.core/bytes data1337)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1338 "Siphash-2-4")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-siphash1336
    [data1337 key1338]
    (clojure.core/let
     [data1337 (.getBytes data1337 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "Siphash-2-4")
       msg__542__auto__
       (clojure.core/bytes data1337)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1338 "Siphash-2-4")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1339
   java.io.InputStream
   (compute-siphash1336
    [data1337 key1338]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "Siphash-2-4")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1338 "Siphash-2-4")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1337]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-siphash1336
    [data1337 key1338]
    (clojure.core/with-open
     [data1337 (clojure.java.io/input-stream data1337)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "Siphash-2-4")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1338 "Siphash-2-4")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1337]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1339)
 (do
  (clojure.core/defn
   siphash*
   "[HMAC] Siphash-2-4 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-siphash1336
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   siphash-file*
   "[HMAC] Siphash-2-4 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-siphash1336
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   siphash-bytes
   "[HMAC] Siphash-2-4 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-siphash1336
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   siphash-file-bytes
   "[HMAC] Siphash-2-4 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-siphash1336
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   siphash
   "[HMAC] Siphash-2-4 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-siphash1336
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   siphash-file
   "[HMAC] Siphash-2-4 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-siphash1336
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
