(ns
 pandect.algo.keccak-512
 "Keccak-512 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol
   G__1170
   (compute-keccak-5121162 [data1166]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1170 #'compute-keccak-5121162]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1170
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-keccak-5121162
    [data1166]
    (clojure.core/let
     [md__666__auto__
      (java.security.MessageDigest/getInstance "Keccak-512")]
     (.digest md__666__auto__ data1166)))
   java.lang.String
   (compute-keccak-5121162
    [data1166]
    (clojure.core/let
     [data1166 (.getBytes data1166 "UTF-8")]
     (clojure.core/let
      [md__666__auto__
       (java.security.MessageDigest/getInstance "Keccak-512")]
      (.digest md__666__auto__ data1166)))))
  (clojure.core/extend-protocol
   G__1170
   java.io.InputStream
   (compute-keccak-5121162
    [data1166]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "Keccak-512")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1166]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-keccak-5121162
    [data1166]
    (clojure.core/with-open
     [data1166 (clojure.java.io/input-stream data1166)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "Keccak-512")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1166]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1170)
 (do
  (clojure.core/defn
   keccak-512*
   "[Hash] Keccak-512 (raw value)"
   [x]
   (compute-keccak-5121162 x))
  (clojure.core/defn
   keccak-512-file*
   "[Hash] Keccak-512 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-5121162 x)))
  (clojure.core/defn
   keccak-512-bytes
   "[Hash] Keccak-512 (value -> byte array)"
   [x]
   (compute-keccak-5121162 x))
  (clojure.core/defn
   keccak-512-file-bytes
   "[Hash] Keccak-512 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-5121162 x)))
  (clojure.core/defn
   keccak-512
   "[Hash] Keccak-512 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-keccak-5121162 x)))
  (clojure.core/defn
   keccak-512-file
   "[Hash] Keccak-512 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-keccak-5121162 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1198
   (compute-keccak-5121195 [data1196 key1197]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1198 #'compute-keccak-5121195]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1198
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-keccak-5121195
    [data1196 key1197]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "Hmac-Keccak512")
      msg__542__auto__
      (clojure.core/bytes data1196)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1197 "Hmac-Keccak512")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-keccak-5121195
    [data1196 key1197]
    (clojure.core/let
     [data1196 (.getBytes data1196 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "Hmac-Keccak512")
       msg__542__auto__
       (clojure.core/bytes data1196)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1197 "Hmac-Keccak512")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1198
   java.io.InputStream
   (compute-keccak-5121195
    [data1196 key1197]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "Hmac-Keccak512")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1197 "Hmac-Keccak512")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1196]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-keccak-5121195
    [data1196 key1197]
    (clojure.core/with-open
     [data1196 (clojure.java.io/input-stream data1196)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "Hmac-Keccak512")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1197 "Hmac-Keccak512")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1196]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1198)
 (do
  (clojure.core/defn
   keccak-512-hmac*
   "[HMAC] Hmac-Keccak512 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-keccak-5121195
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   keccak-512-hmac-file*
   "[HMAC] Hmac-Keccak512 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-5121195
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-512-hmac-bytes
   "[HMAC] Hmac-Keccak512 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-keccak-5121195
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   keccak-512-hmac-file-bytes
   "[HMAC] Hmac-Keccak512 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-5121195
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-512-hmac
   "[HMAC] Hmac-Keccak512 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-keccak-5121195
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-512-hmac-file
   "[HMAC] Hmac-Keccak512 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-keccak-5121195
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
