(ns
 pandect.algo.keccak-256
 "Keccak-256 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol
   G__1171
   (compute-keccak-2561165 [data1168]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1171 #'compute-keccak-2561165]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1171
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-keccak-2561165
    [data1168]
    (clojure.core/let
     [md__666__auto__
      (java.security.MessageDigest/getInstance "Keccak-256")]
     (.digest md__666__auto__ data1168)))
   java.lang.String
   (compute-keccak-2561165
    [data1168]
    (clojure.core/let
     [data1168 (.getBytes data1168 "UTF-8")]
     (clojure.core/let
      [md__666__auto__
       (java.security.MessageDigest/getInstance "Keccak-256")]
      (.digest md__666__auto__ data1168)))))
  (clojure.core/extend-protocol
   G__1171
   java.io.InputStream
   (compute-keccak-2561165
    [data1168]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "Keccak-256")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1168]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-keccak-2561165
    [data1168]
    (clojure.core/with-open
     [data1168 (clojure.java.io/input-stream data1168)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "Keccak-256")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1168]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1171)
 (do
  (clojure.core/defn
   keccak-256*
   "[Hash] Keccak-256 (raw value)"
   [x]
   (compute-keccak-2561165 x))
  (clojure.core/defn
   keccak-256-file*
   "[Hash] Keccak-256 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-2561165 x)))
  (clojure.core/defn
   keccak-256-bytes
   "[Hash] Keccak-256 (value -> byte array)"
   [x]
   (compute-keccak-2561165 x))
  (clojure.core/defn
   keccak-256-file-bytes
   "[Hash] Keccak-256 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-2561165 x)))
  (clojure.core/defn
   keccak-256
   "[Hash] Keccak-256 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-keccak-2561165 x)))
  (clojure.core/defn
   keccak-256-file
   "[Hash] Keccak-256 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-keccak-2561165 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1206
   (compute-keccak-2561203 [data1204 key1205]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1206 #'compute-keccak-2561203]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1206
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-keccak-2561203
    [data1204 key1205]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "Hmac-Keccak256")
      msg__542__auto__
      (clojure.core/bytes data1204)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1205 "Hmac-Keccak256")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-keccak-2561203
    [data1204 key1205]
    (clojure.core/let
     [data1204 (.getBytes data1204 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "Hmac-Keccak256")
       msg__542__auto__
       (clojure.core/bytes data1204)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1205 "Hmac-Keccak256")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1206
   java.io.InputStream
   (compute-keccak-2561203
    [data1204 key1205]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "Hmac-Keccak256")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1205 "Hmac-Keccak256")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1204]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-keccak-2561203
    [data1204 key1205]
    (clojure.core/with-open
     [data1204 (clojure.java.io/input-stream data1204)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "Hmac-Keccak256")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1205 "Hmac-Keccak256")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1204]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1206)
 (do
  (clojure.core/defn
   keccak-256-hmac*
   "[HMAC] Hmac-Keccak256 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-keccak-2561203
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   keccak-256-hmac-file*
   "[HMAC] Hmac-Keccak256 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-2561203
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-256-hmac-bytes
   "[HMAC] Hmac-Keccak256 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-keccak-2561203
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   keccak-256-hmac-file-bytes
   "[HMAC] Hmac-Keccak256 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-2561203
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-256-hmac
   "[HMAC] Hmac-Keccak256 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-keccak-2561203
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-256-hmac-file
   "[HMAC] Hmac-Keccak256 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-keccak-2561203
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
