(ns
 pandect.algo.gost
 "GOST3411 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1174 (compute-gost1172 [data1173]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1174 #'compute-gost1172]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1174
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-gost1172
    [data1173]
    (clojure.core/let
     [md__666__auto__
      (java.security.MessageDigest/getInstance "GOST3411")]
     (.digest md__666__auto__ data1173)))
   java.lang.String
   (compute-gost1172
    [data1173]
    (clojure.core/let
     [data1173 (.getBytes data1173 "UTF-8")]
     (clojure.core/let
      [md__666__auto__
       (java.security.MessageDigest/getInstance "GOST3411")]
      (.digest md__666__auto__ data1173)))))
  (clojure.core/extend-protocol
   G__1174
   java.io.InputStream
   (compute-gost1172
    [data1173]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "GOST3411")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1173]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-gost1172
    [data1173]
    (clojure.core/with-open
     [data1173 (clojure.java.io/input-stream data1173)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "GOST3411")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1173]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1174)
 (do
  (clojure.core/defn
   gost*
   "[Hash] GOST3411 (raw value)"
   [x]
   (compute-gost1172 x))
  (clojure.core/defn
   gost-file*
   "[Hash] GOST3411 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-gost1172 x)))
  (clojure.core/defn
   gost-bytes
   "[Hash] GOST3411 (value -> byte array)"
   [x]
   (compute-gost1172 x))
  (clojure.core/defn
   gost-file-bytes
   "[Hash] GOST3411 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-gost1172 x)))
  (clojure.core/defn
   gost
   "[Hash] GOST3411 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-gost1172 x)))
  (clojure.core/defn
   gost-file
   "[Hash] GOST3411 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-gost1172 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1210
   (compute-gost1207 [data1208 key1209]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1210 #'compute-gost1207]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1210
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-gost1207
    [data1208 key1209]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "Hmac-GOST3411")
      msg__542__auto__
      (clojure.core/bytes data1208)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1209 "Hmac-GOST3411")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-gost1207
    [data1208 key1209]
    (clojure.core/let
     [data1208 (.getBytes data1208 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "Hmac-GOST3411")
       msg__542__auto__
       (clojure.core/bytes data1208)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1209 "Hmac-GOST3411")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1210
   java.io.InputStream
   (compute-gost1207
    [data1208 key1209]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "Hmac-GOST3411")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1209 "Hmac-GOST3411")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1208]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-gost1207
    [data1208 key1209]
    (clojure.core/with-open
     [data1208 (clojure.java.io/input-stream data1208)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "Hmac-GOST3411")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1209 "Hmac-GOST3411")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1208]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1210)
 (do
  (clojure.core/defn
   gost-hmac*
   "[HMAC] Hmac-GOST3411 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-gost1207
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   gost-hmac-file*
   "[HMAC] Hmac-GOST3411 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-gost1207
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   gost-hmac-bytes
   "[HMAC] Hmac-GOST3411 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-gost1207
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   gost-hmac-file-bytes
   "[HMAC] Hmac-GOST3411 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-gost1207
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   gost-hmac
   "[HMAC] Hmac-GOST3411 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-gost1207
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   gost-hmac-file
   "[HMAC] Hmac-GOST3411 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-gost1207
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
