(ns
 pandect.algo.sha3-512
 "SHA3-512 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1328 (compute-sha3-5121326 [data1327]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1328 #'compute-sha3-5121326]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1328
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha3-5121326
    [data1327]
    (clojure.core/let
     [md__666__auto__
      (java.security.MessageDigest/getInstance "SHA3-512")]
     (.digest md__666__auto__ data1327)))
   java.lang.String
   (compute-sha3-5121326
    [data1327]
    (clojure.core/let
     [data1327 (.getBytes data1327 "UTF-8")]
     (clojure.core/let
      [md__666__auto__
       (java.security.MessageDigest/getInstance "SHA3-512")]
      (.digest md__666__auto__ data1327)))))
  (clojure.core/extend-protocol
   G__1328
   java.io.InputStream
   (compute-sha3-5121326
    [data1327]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "SHA3-512")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1327]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-sha3-5121326
    [data1327]
    (clojure.core/with-open
     [data1327 (clojure.java.io/input-stream data1327)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "SHA3-512")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1327]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1328)
 (do
  (clojure.core/defn
   sha3-512*
   "[Hash] SHA3-512 (raw value)"
   [x]
   (compute-sha3-5121326 x))
  (clojure.core/defn
   sha3-512-file*
   "[Hash] SHA3-512 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3-5121326 x)))
  (clojure.core/defn
   sha3-512-bytes
   "[Hash] SHA3-512 (value -> byte array)"
   [x]
   (compute-sha3-5121326 x))
  (clojure.core/defn
   sha3-512-file-bytes
   "[Hash] SHA3-512 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3-5121326 x)))
  (clojure.core/defn
   sha3-512
   "[Hash] SHA3-512 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-sha3-5121326 x)))
  (clojure.core/defn
   sha3-512-file
   "[Hash] SHA3-512 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-sha3-5121326 x))))))
