(ns
 pandect.algo.sha256
 "SHA-256 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1263 (compute-sha2561261 [data1262]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1263 #'compute-sha2561261]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1263
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha2561261
    [data1262]
    (clojure.core/let
     [md__666__auto__
      (java.security.MessageDigest/getInstance "SHA-256")]
     (.digest md__666__auto__ data1262)))
   java.lang.String
   (compute-sha2561261
    [data1262]
    (clojure.core/let
     [data1262 (.getBytes data1262 "UTF-8")]
     (clojure.core/let
      [md__666__auto__
       (java.security.MessageDigest/getInstance "SHA-256")]
      (.digest md__666__auto__ data1262)))))
  (clojure.core/extend-protocol
   G__1263
   java.io.InputStream
   (compute-sha2561261
    [data1262]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "SHA-256")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1262]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-sha2561261
    [data1262]
    (clojure.core/with-open
     [data1262 (clojure.java.io/input-stream data1262)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "SHA-256")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1262]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1263)
 (do
  (clojure.core/defn
   sha256*
   "[Hash] SHA-256 (raw value)"
   [x]
   (compute-sha2561261 x))
  (clojure.core/defn
   sha256-file*
   "[Hash] SHA-256 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2561261 x)))
  (clojure.core/defn
   sha256-bytes
   "[Hash] SHA-256 (value -> byte array)"
   [x]
   (compute-sha2561261 x))
  (clojure.core/defn
   sha256-file-bytes
   "[Hash] SHA-256 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2561261 x)))
  (clojure.core/defn
   sha256
   "[Hash] SHA-256 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-sha2561261 x)))
  (clojure.core/defn
   sha256-file
   "[Hash] SHA-256 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-sha2561261 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1285
   (compute-sha2561282 [data1283 key1284]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1285 #'compute-sha2561282]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1285
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha2561282
    [data1283 key1284]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "HmacSHA256")
      msg__542__auto__
      (clojure.core/bytes data1283)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1284 "HmacSHA256")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-sha2561282
    [data1283 key1284]
    (clojure.core/let
     [data1283 (.getBytes data1283 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "HmacSHA256")
       msg__542__auto__
       (clojure.core/bytes data1283)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1284 "HmacSHA256")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1285
   java.io.InputStream
   (compute-sha2561282
    [data1283 key1284]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "HmacSHA256")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1284 "HmacSHA256")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1283]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-sha2561282
    [data1283 key1284]
    (clojure.core/with-open
     [data1283 (clojure.java.io/input-stream data1283)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "HmacSHA256")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1284 "HmacSHA256")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1283]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1285)
 (do
  (clojure.core/defn
   sha256-hmac*
   "[HMAC] HmacSHA256 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha2561282
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha256-hmac-file*
   "[HMAC] HmacSHA256 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2561282
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha256-hmac-bytes
   "[HMAC] HmacSHA256 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha2561282
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha256-hmac-file-bytes
   "[HMAC] HmacSHA256 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2561282
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha256-hmac
   "[HMAC] HmacSHA256 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-sha2561282
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha256-hmac-file
   "[HMAC] HmacSHA256 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha2561282
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
(do
 (do
  (clojure.core/defprotocol
   G__1317
   (compute-sha2561313 [data1314 key1316])
   (compute-sha2561313-verify [data1314 sig1315 key1316]))
  (clojure.core/doseq
   [v__184__auto__
    [#'G__1317 #'compute-sha2561313 #'compute-sha2561313-verify]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1317
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha2561313
    [data1314 key1316]
    (clojure.core/let
     [signer__845__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA256withRSA")
       (.initSign key1316)
       (.update (clojure.core/bytes data1314)))]
     (.sign signer__845__auto__)))
   (compute-sha2561313-verify
    [data1314 sig1315 key1316]
    (clojure.core/let
     [signer__846__auto__
      (java.security.Signature/getInstance "SHA256withRSA")
      key__847__auto__
      (pandect.utils.convert/as-public-key key1316)]
     (.initVerify signer__846__auto__ key__847__auto__)
     (.update signer__846__auto__ (clojure.core/bytes data1314))
     (.verify signer__846__auto__ (clojure.core/bytes sig1315))))
   java.lang.String
   (compute-sha2561313
    [data1314 key1316]
    (clojure.core/let
     [data1314 (.getBytes data1314 "UTF-8")]
     (clojure.core/let
      [signer__845__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA256withRSA")
        (.initSign key1316)
        (.update (clojure.core/bytes data1314)))]
      (.sign signer__845__auto__))))
   (compute-sha2561313-verify
    [data1314 sig1315 key1316]
    (clojure.core/let
     [data1314 (.getBytes data1314 "UTF-8")]
     (clojure.core/let
      [signer__846__auto__
       (java.security.Signature/getInstance "SHA256withRSA")
       key__847__auto__
       (pandect.utils.convert/as-public-key key1316)]
      (.initVerify signer__846__auto__ key__847__auto__)
      (.update signer__846__auto__ (clojure.core/bytes data1314))
      (.verify signer__846__auto__ (clojure.core/bytes sig1315))))))
  (clojure.core/extend-protocol
   G__1317
   java.io.InputStream
   (compute-sha2561313
    [data1314 key1316]
    (clojure.core/let
     [signer__848__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA256withRSA")
       (.initSign key1316))
      c__849__auto__
      (clojure.core/int *buffer-size*)
      buf__850__auto__
      (clojure.core/byte-array c__849__auto__)
      s__851__auto__
      data1314]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__852__auto__
        (.read s__851__auto__ buf__850__auto__ 0 c__849__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__852__auto__ -1)
        (.update signer__848__auto__ buf__850__auto__ 0 r__852__auto__)
        (recur))))
     (.sign signer__848__auto__)))
   (compute-sha2561313-verify
    [data1314 sig1315 key1316]
    (clojure.core/let
     [signer__853__auto__
      (java.security.Signature/getInstance "SHA256withRSA")
      c__854__auto__
      (clojure.core/int *buffer-size*)
      buf__855__auto__
      (clojure.core/byte-array c__854__auto__)
      s__856__auto__
      data1314
      key__857__auto__
      (pandect.utils.convert/as-public-key key1316)]
     (.initVerify signer__853__auto__ key__857__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__858__auto__
        (.read s__856__auto__ buf__855__auto__ 0 c__854__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__858__auto__ -1)
        (.update signer__853__auto__ buf__855__auto__ 0 r__858__auto__)
        (recur))))
     (.verify signer__853__auto__ (clojure.core/bytes sig1315))))
   java.io.File
   (compute-sha2561313
    [data1314 key1316]
    (clojure.core/with-open
     [data1314 (clojure.java.io/input-stream data1314)]
     (clojure.core/let
      [signer__848__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA256withRSA")
        (.initSign key1316))
       c__849__auto__
       (clojure.core/int *buffer-size*)
       buf__850__auto__
       (clojure.core/byte-array c__849__auto__)
       s__851__auto__
       data1314]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__852__auto__
         (.read s__851__auto__ buf__850__auto__ 0 c__849__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__852__auto__ -1)
         (.update
          signer__848__auto__
          buf__850__auto__
          0
          r__852__auto__)
         (recur))))
      (.sign signer__848__auto__))))
   (compute-sha2561313-verify
    [data1314 sig1315 key1316]
    (clojure.core/with-open
     [data1314 (clojure.java.io/input-stream data1314)]
     (clojure.core/let
      [signer__853__auto__
       (java.security.Signature/getInstance "SHA256withRSA")
       c__854__auto__
       (clojure.core/int *buffer-size*)
       buf__855__auto__
       (clojure.core/byte-array c__854__auto__)
       s__856__auto__
       data1314
       key__857__auto__
       (pandect.utils.convert/as-public-key key1316)]
      (.initVerify signer__853__auto__ key__857__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__858__auto__
         (.read s__856__auto__ buf__855__auto__ 0 c__854__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__858__auto__ -1)
         (.update
          signer__853__auto__
          buf__855__auto__
          0
          r__858__auto__)
         (recur))))
      (.verify signer__853__auto__ (clojure.core/bytes sig1315))))))
  'G__1317)
 (do
  (clojure.core/defn
   sha256-rsa*
   "[Signature] SHA256withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha2561313 x private-key))
  (clojure.core/defn
   sha256-rsa-file*
   "[Signature] SHA256withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2561313 x private-key)))
  (clojure.core/defn
   sha256-rsa-bytes
   "[Signature] SHA256withRSA (value -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha2561313 x private-key))
  (clojure.core/defn
   sha256-rsa-file-bytes
   "[Signature] SHA256withRSA (file path -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2561313 x private-key)))
  (clojure.core/defn
   sha256-rsa
   "[Signature] SHA256withRSA (value -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (pandect.utils.convert/bytes->hex
    (compute-sha2561313 x private-key)))
  (clojure.core/defn
   sha256-rsa-file
   "[Signature] SHA256withRSA (file path -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha2561313 x private-key))))
  (clojure.core/defn
   sha256-rsa-verify
   "[Signature] SHA256withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (compute-sha2561313-verify
    x
    (pandect.utils.convert/convert-signature-to-byte-array signature)
    (pandect.utils.convert/convert-to-public-key public-key)))
  (clojure.core/defn
   sha256-rsa-verify-file
   "[Signature] SHA256withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2561313-verify
     x
     (pandect.utils.convert/convert-signature-to-byte-array signature)
     (pandect.utils.convert/convert-to-public-key public-key))))))
