(ns
 pandect.algo.sha224
 "SHA-224 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1272 (compute-sha2241270 [data1271]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1272 #'compute-sha2241270]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1272
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha2241270
    [data1271]
    (clojure.core/let
     [md__666__auto__
      (java.security.MessageDigest/getInstance "SHA-224")]
     (.digest md__666__auto__ data1271)))
   java.lang.String
   (compute-sha2241270
    [data1271]
    (clojure.core/let
     [data1271 (.getBytes data1271 "UTF-8")]
     (clojure.core/let
      [md__666__auto__
       (java.security.MessageDigest/getInstance "SHA-224")]
      (.digest md__666__auto__ data1271)))))
  (clojure.core/extend-protocol
   G__1272
   java.io.InputStream
   (compute-sha2241270
    [data1271]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "SHA-224")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1271]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-sha2241270
    [data1271]
    (clojure.core/with-open
     [data1271 (clojure.java.io/input-stream data1271)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "SHA-224")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1271]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1272)
 (do
  (clojure.core/defn
   sha224*
   "[Hash] SHA-224 (raw value)"
   [x]
   (compute-sha2241270 x))
  (clojure.core/defn
   sha224-file*
   "[Hash] SHA-224 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2241270 x)))
  (clojure.core/defn
   sha224-bytes
   "[Hash] SHA-224 (value -> byte array)"
   [x]
   (compute-sha2241270 x))
  (clojure.core/defn
   sha224-file-bytes
   "[Hash] SHA-224 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2241270 x)))
  (clojure.core/defn
   sha224
   "[Hash] SHA-224 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-sha2241270 x)))
  (clojure.core/defn
   sha224-file
   "[Hash] SHA-224 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-sha2241270 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1297
   (compute-sha2241294 [data1295 key1296]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1297 #'compute-sha2241294]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1297
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha2241294
    [data1295 key1296]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "Hmac-SHA224")
      msg__542__auto__
      (clojure.core/bytes data1295)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1296 "Hmac-SHA224")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-sha2241294
    [data1295 key1296]
    (clojure.core/let
     [data1295 (.getBytes data1295 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "Hmac-SHA224")
       msg__542__auto__
       (clojure.core/bytes data1295)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1296 "Hmac-SHA224")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1297
   java.io.InputStream
   (compute-sha2241294
    [data1295 key1296]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "Hmac-SHA224")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1296 "Hmac-SHA224")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1295]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-sha2241294
    [data1295 key1296]
    (clojure.core/with-open
     [data1295 (clojure.java.io/input-stream data1295)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "Hmac-SHA224")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1296 "Hmac-SHA224")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1295]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1297)
 (do
  (clojure.core/defn
   sha224-hmac*
   "[HMAC] Hmac-SHA224 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha2241294
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha224-hmac-file*
   "[HMAC] Hmac-SHA224 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2241294
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha224-hmac-bytes
   "[HMAC] Hmac-SHA224 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha2241294
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha224-hmac-file-bytes
   "[HMAC] Hmac-SHA224 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2241294
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha224-hmac
   "[HMAC] Hmac-SHA224 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-sha2241294
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha224-hmac-file
   "[HMAC] Hmac-SHA224 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha2241294
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
