(ns
 pandect.algo.ripemd320
 "RipeMD320 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1269 (compute-ripemd3201267 [data1268]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1269 #'compute-ripemd3201267]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1269
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-ripemd3201267
    [data1268]
    (clojure.core/let
     [md__666__auto__
      (java.security.MessageDigest/getInstance "RipeMD320")]
     (.digest md__666__auto__ data1268)))
   java.lang.String
   (compute-ripemd3201267
    [data1268]
    (clojure.core/let
     [data1268 (.getBytes data1268 "UTF-8")]
     (clojure.core/let
      [md__666__auto__
       (java.security.MessageDigest/getInstance "RipeMD320")]
      (.digest md__666__auto__ data1268)))))
  (clojure.core/extend-protocol
   G__1269
   java.io.InputStream
   (compute-ripemd3201267
    [data1268]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "RipeMD320")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1268]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-ripemd3201267
    [data1268]
    (clojure.core/with-open
     [data1268 (clojure.java.io/input-stream data1268)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "RipeMD320")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1268]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1269)
 (do
  (clojure.core/defn
   ripemd320*
   "[Hash] RipeMD320 (raw value)"
   [x]
   (compute-ripemd3201267 x))
  (clojure.core/defn
   ripemd320-file*
   "[Hash] RipeMD320 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd3201267 x)))
  (clojure.core/defn
   ripemd320-bytes
   "[Hash] RipeMD320 (value -> byte array)"
   [x]
   (compute-ripemd3201267 x))
  (clojure.core/defn
   ripemd320-file-bytes
   "[Hash] RipeMD320 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd3201267 x)))
  (clojure.core/defn
   ripemd320
   "[Hash] RipeMD320 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-ripemd3201267 x)))
  (clojure.core/defn
   ripemd320-file
   "[Hash] RipeMD320 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-ripemd3201267 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1293
   (compute-ripemd3201290 [data1291 key1292]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1293 #'compute-ripemd3201290]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1293
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-ripemd3201290
    [data1291 key1292]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "Hmac-RipeMD320")
      msg__542__auto__
      (clojure.core/bytes data1291)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1292 "Hmac-RipeMD320")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-ripemd3201290
    [data1291 key1292]
    (clojure.core/let
     [data1291 (.getBytes data1291 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "Hmac-RipeMD320")
       msg__542__auto__
       (clojure.core/bytes data1291)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1292 "Hmac-RipeMD320")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1293
   java.io.InputStream
   (compute-ripemd3201290
    [data1291 key1292]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "Hmac-RipeMD320")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1292 "Hmac-RipeMD320")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1291]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-ripemd3201290
    [data1291 key1292]
    (clojure.core/with-open
     [data1291 (clojure.java.io/input-stream data1291)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "Hmac-RipeMD320")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1292 "Hmac-RipeMD320")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1291]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1293)
 (do
  (clojure.core/defn
   ripemd320-hmac*
   "[HMAC] Hmac-RipeMD320 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-ripemd3201290
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   ripemd320-hmac-file*
   "[HMAC] Hmac-RipeMD320 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd3201290
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd320-hmac-bytes
   "[HMAC] Hmac-RipeMD320 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-ripemd3201290
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   ripemd320-hmac-file-bytes
   "[HMAC] Hmac-RipeMD320 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd3201290
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd320-hmac
   "[HMAC] Hmac-RipeMD320 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-ripemd3201290
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd320-hmac-file
   "[HMAC] Hmac-RipeMD320 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-ripemd3201290
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
