(ns
 pandect.algo.md5
 "MD5 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1220 (compute-md51218 [data1219]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1220 #'compute-md51218]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1220
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md51218
    [data1219]
    (clojure.core/let
     [md__666__auto__ (java.security.MessageDigest/getInstance "MD5")]
     (.digest md__666__auto__ data1219)))
   java.lang.String
   (compute-md51218
    [data1219]
    (clojure.core/let
     [data1219 (.getBytes data1219 "UTF-8")]
     (clojure.core/let
      [md__666__auto__ (java.security.MessageDigest/getInstance "MD5")]
      (.digest md__666__auto__ data1219)))))
  (clojure.core/extend-protocol
   G__1220
   java.io.InputStream
   (compute-md51218
    [data1219]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "MD5")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1219]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-md51218
    [data1219]
    (clojure.core/with-open
     [data1219 (clojure.java.io/input-stream data1219)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "MD5")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1219]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1220)
 (do
  (clojure.core/defn
   md5*
   "[Hash] MD5 (raw value)"
   [x]
   (compute-md51218 x))
  (clojure.core/defn
   md5-file*
   "[Hash] MD5 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51218 x)))
  (clojure.core/defn
   md5-bytes
   "[Hash] MD5 (value -> byte array)"
   [x]
   (compute-md51218 x))
  (clojure.core/defn
   md5-file-bytes
   "[Hash] MD5 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51218 x)))
  (clojure.core/defn
   md5
   "[Hash] MD5 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-md51218 x)))
  (clojure.core/defn
   md5-file
   "[Hash] MD5 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-md51218 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1236
   (compute-md51233 [data1234 key1235]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1236 #'compute-md51233]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1236
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md51233
    [data1234 key1235]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "HmacMD5")
      msg__542__auto__
      (clojure.core/bytes data1234)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1235 "HmacMD5")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-md51233
    [data1234 key1235]
    (clojure.core/let
     [data1234 (.getBytes data1234 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "HmacMD5")
       msg__542__auto__
       (clojure.core/bytes data1234)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1235 "HmacMD5")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1236
   java.io.InputStream
   (compute-md51233
    [data1234 key1235]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "HmacMD5")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1235 "HmacMD5")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1234]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-md51233
    [data1234 key1235]
    (clojure.core/with-open
     [data1234 (clojure.java.io/input-stream data1234)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "HmacMD5")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1235 "HmacMD5")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1234]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1236)
 (do
  (clojure.core/defn
   md5-hmac*
   "[HMAC] HmacMD5 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-md51233
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   md5-hmac-file*
   "[HMAC] HmacMD5 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51233
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   md5-hmac-bytes
   "[HMAC] HmacMD5 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-md51233
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   md5-hmac-file-bytes
   "[HMAC] HmacMD5 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51233
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   md5-hmac
   "[HMAC] HmacMD5 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-md51233
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   md5-hmac-file
   "[HMAC] HmacMD5 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-md51233
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
(do
 (do
  (clojure.core/defprotocol
   G__1277
   (compute-md51273 [data1274 key1276])
   (compute-md51273-verify [data1274 sig1275 key1276]))
  (clojure.core/doseq
   [v__184__auto__
    [#'G__1277 #'compute-md51273 #'compute-md51273-verify]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1277
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md51273
    [data1274 key1276]
    (clojure.core/let
     [signer__845__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "MD5withRSA")
       (.initSign key1276)
       (.update (clojure.core/bytes data1274)))]
     (.sign signer__845__auto__)))
   (compute-md51273-verify
    [data1274 sig1275 key1276]
    (clojure.core/let
     [signer__846__auto__
      (java.security.Signature/getInstance "MD5withRSA")
      key__847__auto__
      (pandect.utils.convert/as-public-key key1276)]
     (.initVerify signer__846__auto__ key__847__auto__)
     (.update signer__846__auto__ (clojure.core/bytes data1274))
     (.verify signer__846__auto__ (clojure.core/bytes sig1275))))
   java.lang.String
   (compute-md51273
    [data1274 key1276]
    (clojure.core/let
     [data1274 (.getBytes data1274 "UTF-8")]
     (clojure.core/let
      [signer__845__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "MD5withRSA")
        (.initSign key1276)
        (.update (clojure.core/bytes data1274)))]
      (.sign signer__845__auto__))))
   (compute-md51273-verify
    [data1274 sig1275 key1276]
    (clojure.core/let
     [data1274 (.getBytes data1274 "UTF-8")]
     (clojure.core/let
      [signer__846__auto__
       (java.security.Signature/getInstance "MD5withRSA")
       key__847__auto__
       (pandect.utils.convert/as-public-key key1276)]
      (.initVerify signer__846__auto__ key__847__auto__)
      (.update signer__846__auto__ (clojure.core/bytes data1274))
      (.verify signer__846__auto__ (clojure.core/bytes sig1275))))))
  (clojure.core/extend-protocol
   G__1277
   java.io.InputStream
   (compute-md51273
    [data1274 key1276]
    (clojure.core/let
     [signer__848__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "MD5withRSA")
       (.initSign key1276))
      c__849__auto__
      (clojure.core/int *buffer-size*)
      buf__850__auto__
      (clojure.core/byte-array c__849__auto__)
      s__851__auto__
      data1274]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__852__auto__
        (.read s__851__auto__ buf__850__auto__ 0 c__849__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__852__auto__ -1)
        (.update signer__848__auto__ buf__850__auto__ 0 r__852__auto__)
        (recur))))
     (.sign signer__848__auto__)))
   (compute-md51273-verify
    [data1274 sig1275 key1276]
    (clojure.core/let
     [signer__853__auto__
      (java.security.Signature/getInstance "MD5withRSA")
      c__854__auto__
      (clojure.core/int *buffer-size*)
      buf__855__auto__
      (clojure.core/byte-array c__854__auto__)
      s__856__auto__
      data1274
      key__857__auto__
      (pandect.utils.convert/as-public-key key1276)]
     (.initVerify signer__853__auto__ key__857__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__858__auto__
        (.read s__856__auto__ buf__855__auto__ 0 c__854__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__858__auto__ -1)
        (.update signer__853__auto__ buf__855__auto__ 0 r__858__auto__)
        (recur))))
     (.verify signer__853__auto__ (clojure.core/bytes sig1275))))
   java.io.File
   (compute-md51273
    [data1274 key1276]
    (clojure.core/with-open
     [data1274 (clojure.java.io/input-stream data1274)]
     (clojure.core/let
      [signer__848__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "MD5withRSA")
        (.initSign key1276))
       c__849__auto__
       (clojure.core/int *buffer-size*)
       buf__850__auto__
       (clojure.core/byte-array c__849__auto__)
       s__851__auto__
       data1274]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__852__auto__
         (.read s__851__auto__ buf__850__auto__ 0 c__849__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__852__auto__ -1)
         (.update
          signer__848__auto__
          buf__850__auto__
          0
          r__852__auto__)
         (recur))))
      (.sign signer__848__auto__))))
   (compute-md51273-verify
    [data1274 sig1275 key1276]
    (clojure.core/with-open
     [data1274 (clojure.java.io/input-stream data1274)]
     (clojure.core/let
      [signer__853__auto__
       (java.security.Signature/getInstance "MD5withRSA")
       c__854__auto__
       (clojure.core/int *buffer-size*)
       buf__855__auto__
       (clojure.core/byte-array c__854__auto__)
       s__856__auto__
       data1274
       key__857__auto__
       (pandect.utils.convert/as-public-key key1276)]
      (.initVerify signer__853__auto__ key__857__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__858__auto__
         (.read s__856__auto__ buf__855__auto__ 0 c__854__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__858__auto__ -1)
         (.update
          signer__853__auto__
          buf__855__auto__
          0
          r__858__auto__)
         (recur))))
      (.verify signer__853__auto__ (clojure.core/bytes sig1275))))))
  'G__1277)
 (do
  (clojure.core/defn
   md5-rsa*
   "[Signature] MD5withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-md51273 x private-key))
  (clojure.core/defn
   md5-rsa-file*
   "[Signature] MD5withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51273 x private-key)))
  (clojure.core/defn
   md5-rsa-bytes
   "[Signature] MD5withRSA (value -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-md51273 x private-key))
  (clojure.core/defn
   md5-rsa-file-bytes
   "[Signature] MD5withRSA (file path -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51273 x private-key)))
  (clojure.core/defn
   md5-rsa
   "[Signature] MD5withRSA (value -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (pandect.utils.convert/bytes->hex (compute-md51273 x private-key)))
  (clojure.core/defn
   md5-rsa-file
   "[Signature] MD5withRSA (file path -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-md51273 x private-key))))
  (clojure.core/defn
   md5-rsa-verify
   "[Signature] MD5withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (compute-md51273-verify
    x
    (pandect.utils.convert/convert-signature-to-byte-array signature)
    (pandect.utils.convert/convert-to-public-key public-key)))
  (clojure.core/defn
   md5-rsa-verify-file
   "[Signature] MD5withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51273-verify
     x
     (pandect.utils.convert/convert-signature-to-byte-array signature)
     (pandect.utils.convert/convert-to-public-key public-key))))))
