(ns
 pandect.algo.md4
 "MD4 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1229 (compute-md41227 [data1228]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1229 #'compute-md41227]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1229
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md41227
    [data1228]
    (clojure.core/let
     [md__666__auto__ (java.security.MessageDigest/getInstance "MD4")]
     (.digest md__666__auto__ data1228)))
   java.lang.String
   (compute-md41227
    [data1228]
    (clojure.core/let
     [data1228 (.getBytes data1228 "UTF-8")]
     (clojure.core/let
      [md__666__auto__ (java.security.MessageDigest/getInstance "MD4")]
      (.digest md__666__auto__ data1228)))))
  (clojure.core/extend-protocol
   G__1229
   java.io.InputStream
   (compute-md41227
    [data1228]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "MD4")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1228]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-md41227
    [data1228]
    (clojure.core/with-open
     [data1228 (clojure.java.io/input-stream data1228)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "MD4")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1228]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1229)
 (do
  (clojure.core/defn
   md4*
   "[Hash] MD4 (raw value)"
   [x]
   (compute-md41227 x))
  (clojure.core/defn
   md4-file*
   "[Hash] MD4 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md41227 x)))
  (clojure.core/defn
   md4-bytes
   "[Hash] MD4 (value -> byte array)"
   [x]
   (compute-md41227 x))
  (clojure.core/defn
   md4-file-bytes
   "[Hash] MD4 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md41227 x)))
  (clojure.core/defn
   md4
   "[Hash] MD4 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-md41227 x)))
  (clojure.core/defn
   md4-file
   "[Hash] MD4 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-md41227 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1245
   (compute-md41242 [data1243 key1244]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1245 #'compute-md41242]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1245
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md41242
    [data1243 key1244]
    (clojure.core/let
     [mac__541__auto__
      (javax.crypto.Mac/getInstance "Hmac-MD4")
      msg__542__auto__
      (clojure.core/bytes data1243)
      k__543__auto__
      (javax.crypto.spec.SecretKeySpec. key1244 "Hmac-MD4")]
     (clojure.core/->
      (clojure.core/doto
       mac__541__auto__
       (.init k__543__auto__)
       (.update msg__542__auto__))
      (.doFinal))))
   java.lang.String
   (compute-md41242
    [data1243 key1244]
    (clojure.core/let
     [data1243 (.getBytes data1243 "UTF-8")]
     (clojure.core/let
      [mac__541__auto__
       (javax.crypto.Mac/getInstance "Hmac-MD4")
       msg__542__auto__
       (clojure.core/bytes data1243)
       k__543__auto__
       (javax.crypto.spec.SecretKeySpec. key1244 "Hmac-MD4")]
      (clojure.core/->
       (clojure.core/doto
        mac__541__auto__
        (.init k__543__auto__)
        (.update msg__542__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1245
   java.io.InputStream
   (compute-md41242
    [data1243 key1244]
    (clojure.core/let
     [mac__544__auto__
      (javax.crypto.Mac/getInstance "Hmac-MD4")
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1244 "Hmac-MD4")
      c__546__auto__
      (clojure.core/int *buffer-size*)
      buf__547__auto__
      (clojure.core/byte-array c__546__auto__)
      s__548__auto__
      data1243]
     (.init mac__544__auto__ k__545__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__549__auto__
        (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__549__auto__ -1)
        (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
        (recur))))
     (.doFinal mac__544__auto__)))
   java.io.File
   (compute-md41242
    [data1243 key1244]
    (clojure.core/with-open
     [data1243 (clojure.java.io/input-stream data1243)]
     (clojure.core/let
      [mac__544__auto__
       (javax.crypto.Mac/getInstance "Hmac-MD4")
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1244 "Hmac-MD4")
       c__546__auto__
       (clojure.core/int *buffer-size*)
       buf__547__auto__
       (clojure.core/byte-array c__546__auto__)
       s__548__auto__
       data1243]
      (.init mac__544__auto__ k__545__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__549__auto__
         (.read s__548__auto__ buf__547__auto__ 0 c__546__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__549__auto__ -1)
         (.update mac__544__auto__ buf__547__auto__ 0 r__549__auto__)
         (recur))))
      (.doFinal mac__544__auto__)))))
  'G__1245)
 (do
  (clojure.core/defn
   md4-hmac*
   "[HMAC] Hmac-MD4 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-md41242
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   md4-hmac-file*
   "[HMAC] Hmac-MD4 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md41242
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   md4-hmac-bytes
   "[HMAC] Hmac-MD4 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-md41242
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   md4-hmac-file-bytes
   "[HMAC] Hmac-MD4 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md41242
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   md4-hmac
   "[HMAC] Hmac-MD4 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-md41242
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   md4-hmac-file
   "[HMAC] Hmac-MD4 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-md41242
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
