(ns
 pandect.algo.md2
 "MD2 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1217 (compute-md21215 [data1216]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1217 #'compute-md21215]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1217
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md21215
    [data1216]
    (clojure.core/let
     [md__666__auto__ (java.security.MessageDigest/getInstance "MD2")]
     (.digest md__666__auto__ data1216)))
   java.lang.String
   (compute-md21215
    [data1216]
    (clojure.core/let
     [data1216 (.getBytes data1216 "UTF-8")]
     (clojure.core/let
      [md__666__auto__ (java.security.MessageDigest/getInstance "MD2")]
      (.digest md__666__auto__ data1216)))))
  (clojure.core/extend-protocol
   G__1217
   java.io.InputStream
   (compute-md21215
    [data1216]
    (clojure.core/let
     [md__667__auto__
      (java.security.MessageDigest/getInstance "MD2")
      c__668__auto__
      (clojure.core/int *buffer-size*)
      buf__669__auto__
      (clojure.core/byte-array c__668__auto__)
      s__670__auto__
      data1216]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__671__auto__
        (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__671__auto__ -1)
        (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
        (recur))))
     (.digest md__667__auto__)))
   java.io.File
   (compute-md21215
    [data1216]
    (clojure.core/with-open
     [data1216 (clojure.java.io/input-stream data1216)]
     (clojure.core/let
      [md__667__auto__
       (java.security.MessageDigest/getInstance "MD2")
       c__668__auto__
       (clojure.core/int *buffer-size*)
       buf__669__auto__
       (clojure.core/byte-array c__668__auto__)
       s__670__auto__
       data1216]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__671__auto__
         (.read s__670__auto__ buf__669__auto__ 0 c__668__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__671__auto__ -1)
         (.update md__667__auto__ buf__669__auto__ 0 r__671__auto__)
         (recur))))
      (.digest md__667__auto__)))))
  'G__1217)
 (do
  (clojure.core/defn
   md2*
   "[Hash] MD2 (raw value)"
   [x]
   (compute-md21215 x))
  (clojure.core/defn
   md2-file*
   "[Hash] MD2 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md21215 x)))
  (clojure.core/defn
   md2-bytes
   "[Hash] MD2 (value -> byte array)"
   [x]
   (compute-md21215 x))
  (clojure.core/defn
   md2-file-bytes
   "[Hash] MD2 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md21215 x)))
  (clojure.core/defn
   md2
   "[Hash] MD2 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-md21215 x)))
  (clojure.core/defn
   md2-file
   "[Hash] MD2 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-md21215 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1241
   (compute-md21237 [data1238 key1240])
   (compute-md21237-verify [data1238 sig1239 key1240]))
  (clojure.core/doseq
   [v__184__auto__
    [#'G__1241 #'compute-md21237 #'compute-md21237-verify]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1241
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md21237
    [data1238 key1240]
    (clojure.core/let
     [signer__845__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "MD2withRSA")
       (.initSign key1240)
       (.update (clojure.core/bytes data1238)))]
     (.sign signer__845__auto__)))
   (compute-md21237-verify
    [data1238 sig1239 key1240]
    (clojure.core/let
     [signer__846__auto__
      (java.security.Signature/getInstance "MD2withRSA")
      key__847__auto__
      (pandect.utils.convert/as-public-key key1240)]
     (.initVerify signer__846__auto__ key__847__auto__)
     (.update signer__846__auto__ (clojure.core/bytes data1238))
     (.verify signer__846__auto__ (clojure.core/bytes sig1239))))
   java.lang.String
   (compute-md21237
    [data1238 key1240]
    (clojure.core/let
     [data1238 (.getBytes data1238 "UTF-8")]
     (clojure.core/let
      [signer__845__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "MD2withRSA")
        (.initSign key1240)
        (.update (clojure.core/bytes data1238)))]
      (.sign signer__845__auto__))))
   (compute-md21237-verify
    [data1238 sig1239 key1240]
    (clojure.core/let
     [data1238 (.getBytes data1238 "UTF-8")]
     (clojure.core/let
      [signer__846__auto__
       (java.security.Signature/getInstance "MD2withRSA")
       key__847__auto__
       (pandect.utils.convert/as-public-key key1240)]
      (.initVerify signer__846__auto__ key__847__auto__)
      (.update signer__846__auto__ (clojure.core/bytes data1238))
      (.verify signer__846__auto__ (clojure.core/bytes sig1239))))))
  (clojure.core/extend-protocol
   G__1241
   java.io.InputStream
   (compute-md21237
    [data1238 key1240]
    (clojure.core/let
     [signer__848__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "MD2withRSA")
       (.initSign key1240))
      c__849__auto__
      (clojure.core/int *buffer-size*)
      buf__850__auto__
      (clojure.core/byte-array c__849__auto__)
      s__851__auto__
      data1238]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__852__auto__
        (.read s__851__auto__ buf__850__auto__ 0 c__849__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__852__auto__ -1)
        (.update signer__848__auto__ buf__850__auto__ 0 r__852__auto__)
        (recur))))
     (.sign signer__848__auto__)))
   (compute-md21237-verify
    [data1238 sig1239 key1240]
    (clojure.core/let
     [signer__853__auto__
      (java.security.Signature/getInstance "MD2withRSA")
      c__854__auto__
      (clojure.core/int *buffer-size*)
      buf__855__auto__
      (clojure.core/byte-array c__854__auto__)
      s__856__auto__
      data1238
      key__857__auto__
      (pandect.utils.convert/as-public-key key1240)]
     (.initVerify signer__853__auto__ key__857__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__858__auto__
        (.read s__856__auto__ buf__855__auto__ 0 c__854__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__858__auto__ -1)
        (.update signer__853__auto__ buf__855__auto__ 0 r__858__auto__)
        (recur))))
     (.verify signer__853__auto__ (clojure.core/bytes sig1239))))
   java.io.File
   (compute-md21237
    [data1238 key1240]
    (clojure.core/with-open
     [data1238 (clojure.java.io/input-stream data1238)]
     (clojure.core/let
      [signer__848__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "MD2withRSA")
        (.initSign key1240))
       c__849__auto__
       (clojure.core/int *buffer-size*)
       buf__850__auto__
       (clojure.core/byte-array c__849__auto__)
       s__851__auto__
       data1238]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__852__auto__
         (.read s__851__auto__ buf__850__auto__ 0 c__849__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__852__auto__ -1)
         (.update
          signer__848__auto__
          buf__850__auto__
          0
          r__852__auto__)
         (recur))))
      (.sign signer__848__auto__))))
   (compute-md21237-verify
    [data1238 sig1239 key1240]
    (clojure.core/with-open
     [data1238 (clojure.java.io/input-stream data1238)]
     (clojure.core/let
      [signer__853__auto__
       (java.security.Signature/getInstance "MD2withRSA")
       c__854__auto__
       (clojure.core/int *buffer-size*)
       buf__855__auto__
       (clojure.core/byte-array c__854__auto__)
       s__856__auto__
       data1238
       key__857__auto__
       (pandect.utils.convert/as-public-key key1240)]
      (.initVerify signer__853__auto__ key__857__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__858__auto__
         (.read s__856__auto__ buf__855__auto__ 0 c__854__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__858__auto__ -1)
         (.update
          signer__853__auto__
          buf__855__auto__
          0
          r__858__auto__)
         (recur))))
      (.verify signer__853__auto__ (clojure.core/bytes sig1239))))))
  'G__1241)
 (do
  (clojure.core/defn
   md2-rsa*
   "[Signature] MD2withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-md21237 x private-key))
  (clojure.core/defn
   md2-rsa-file*
   "[Signature] MD2withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md21237 x private-key)))
  (clojure.core/defn
   md2-rsa-bytes
   "[Signature] MD2withRSA (value -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-md21237 x private-key))
  (clojure.core/defn
   md2-rsa-file-bytes
   "[Signature] MD2withRSA (file path -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md21237 x private-key)))
  (clojure.core/defn
   md2-rsa
   "[Signature] MD2withRSA (value -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (pandect.utils.convert/bytes->hex (compute-md21237 x private-key)))
  (clojure.core/defn
   md2-rsa-file
   "[Signature] MD2withRSA (file path -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-md21237 x private-key))))
  (clojure.core/defn
   md2-rsa-verify
   "[Signature] MD2withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (compute-md21237-verify
    x
    (pandect.utils.convert/convert-signature-to-byte-array signature)
    (pandect.utils.convert/convert-to-public-key public-key)))
  (clojure.core/defn
   md2-rsa-verify-file
   "[Signature] MD2withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md21237-verify
     x
     (pandect.utils.convert/convert-signature-to-byte-array signature)
     (pandect.utils.convert/convert-to-public-key public-key))))))
