(ns
 pandect.algo.crc32
 "CRC-32 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1189 (compute-crc321186 [data1188]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1189 #'compute-crc321186]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1189
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-crc321186
    [data1188]
    (clojure.core/let
     [buf__896__auto__
      (clojure.core/bytes data1188)
      a__897__auto__
      (new java.util.zip.CRC32)]
     (.update
      a__897__auto__
      buf__896__auto__
      0
      (clojure.core/alength buf__896__auto__))
     (.getValue a__897__auto__)))
   java.lang.String
   (compute-crc321186
    [data1188]
    (clojure.core/let
     [data1188 (.getBytes data1188 "UTF-8")]
     (clojure.core/let
      [buf__896__auto__
       (clojure.core/bytes data1188)
       a__897__auto__
       (new java.util.zip.CRC32)]
      (.update
       a__897__auto__
       buf__896__auto__
       0
       (clojure.core/alength buf__896__auto__))
      (.getValue a__897__auto__)))))
  (clojure.core/extend-protocol
   G__1189
   java.io.InputStream
   (compute-crc321186
    [data1188]
    (clojure.core/let
     [s__898__auto__
      data1188
      c__899__auto__
      (clojure.core/int *buffer-size*)
      buf__900__auto__
      (clojure.core/byte-array c__899__auto__)
      a__901__auto__
      (new java.util.zip.CRC32)]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__902__auto__
        (.read s__898__auto__ buf__900__auto__ 0 c__899__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__902__auto__ -1)
        (.update a__901__auto__ buf__900__auto__ 0 r__902__auto__)
        (recur))))
     (.getValue a__901__auto__)))
   java.io.File
   (compute-crc321186
    [data1188]
    (clojure.core/with-open
     [data1188 (clojure.java.io/input-stream data1188)]
     (clojure.core/let
      [s__898__auto__
       data1188
       c__899__auto__
       (clojure.core/int *buffer-size*)
       buf__900__auto__
       (clojure.core/byte-array c__899__auto__)
       a__901__auto__
       (new java.util.zip.CRC32)]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__902__auto__
         (.read s__898__auto__ buf__900__auto__ 0 c__899__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__902__auto__ -1)
         (.update a__901__auto__ buf__900__auto__ 0 r__902__auto__)
         (recur))))
      (.getValue a__901__auto__)))))
  'G__1189)
 (do
  (clojure.core/defn
   crc32*
   "[Hash] CRC-32 (raw value)"
   [x]
   (compute-crc321186 x))
  (clojure.core/defn
   crc32-file*
   "[Hash] CRC-32 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-crc321186 x)))
  (clojure.core/defn
   crc32-bytes
   "[Hash] CRC-32 (value -> byte array)"
   [x]
   (pandect.utils.convert/long->4-bytes (compute-crc321186 x)))
  (clojure.core/defn
   crc32-file-bytes
   "[Hash] CRC-32 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/long->4-bytes (compute-crc321186 x))))
  (clojure.core/defn
   crc32
   "[Hash] CRC-32 (value -> string)"
   [x]
   (pandect.utils.convert/long->hex (compute-crc321186 x)))
  (clojure.core/defn
   crc32-file
   "[Hash] CRC-32 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/long->hex (compute-crc321186 x))))))
