(ns
 pandect.algo.adler32
 "ADLER-32 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1177 (compute-adler321175 [data1176]))
  (clojure.core/doseq
   [v__184__auto__ [#'G__1177 #'compute-adler321175]]
   (clojure.core/alter-meta!
    v__184__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1177
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-adler321175
    [data1176]
    (clojure.core/let
     [buf__896__auto__
      (clojure.core/bytes data1176)
      a__897__auto__
      (new java.util.zip.Adler32)]
     (.update
      a__897__auto__
      buf__896__auto__
      0
      (clojure.core/alength buf__896__auto__))
     (.getValue a__897__auto__)))
   java.lang.String
   (compute-adler321175
    [data1176]
    (clojure.core/let
     [data1176 (.getBytes data1176 "UTF-8")]
     (clojure.core/let
      [buf__896__auto__
       (clojure.core/bytes data1176)
       a__897__auto__
       (new java.util.zip.Adler32)]
      (.update
       a__897__auto__
       buf__896__auto__
       0
       (clojure.core/alength buf__896__auto__))
      (.getValue a__897__auto__)))))
  (clojure.core/extend-protocol
   G__1177
   java.io.InputStream
   (compute-adler321175
    [data1176]
    (clojure.core/let
     [s__898__auto__
      data1176
      c__899__auto__
      (clojure.core/int *buffer-size*)
      buf__900__auto__
      (clojure.core/byte-array c__899__auto__)
      a__901__auto__
      (new java.util.zip.Adler32)]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__902__auto__
        (.read s__898__auto__ buf__900__auto__ 0 c__899__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__902__auto__ -1)
        (.update a__901__auto__ buf__900__auto__ 0 r__902__auto__)
        (recur))))
     (.getValue a__901__auto__)))
   java.io.File
   (compute-adler321175
    [data1176]
    (clojure.core/with-open
     [data1176 (clojure.java.io/input-stream data1176)]
     (clojure.core/let
      [s__898__auto__
       data1176
       c__899__auto__
       (clojure.core/int *buffer-size*)
       buf__900__auto__
       (clojure.core/byte-array c__899__auto__)
       a__901__auto__
       (new java.util.zip.Adler32)]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__902__auto__
         (.read s__898__auto__ buf__900__auto__ 0 c__899__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__902__auto__ -1)
         (.update a__901__auto__ buf__900__auto__ 0 r__902__auto__)
         (recur))))
      (.getValue a__901__auto__)))))
  'G__1177)
 (do
  (clojure.core/defn
   adler32*
   "[Hash] ADLER-32 (raw value)"
   [x]
   (compute-adler321175 x))
  (clojure.core/defn
   adler32-file*
   "[Hash] ADLER-32 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-adler321175 x)))
  (clojure.core/defn
   adler32-bytes
   "[Hash] ADLER-32 (value -> byte array)"
   [x]
   (pandect.utils.convert/long->4-bytes (compute-adler321175 x)))
  (clojure.core/defn
   adler32-file-bytes
   "[Hash] ADLER-32 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/long->4-bytes (compute-adler321175 x))))
  (clojure.core/defn
   adler32
   "[Hash] ADLER-32 (value -> string)"
   [x]
   (pandect.utils.convert/long->hex (compute-adler321175 x)))
  (clojure.core/defn
   adler32-file
   "[Hash] ADLER-32 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/long->hex (compute-adler321175 x))))))
